/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzerSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse;

public class ListAnalyzersIterable
implements SdkIterable<ListAnalyzersResponse> {
    private final AccessAnalyzerClient client;
    private final ListAnalyzersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnalyzersIterable(AccessAnalyzerClient client, ListAnalyzersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnalyzersResponseFetcher();
    }

    public Iterator<ListAnalyzersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnalyzerSummary> analyzers() {
        Function<ListAnalyzersResponse, Iterator> getIterator = response -> {
            if (response != null && response.analyzers() != null) {
                return response.analyzers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnalyzersResponseFetcher
    implements SyncPageFetcher<ListAnalyzersResponse> {
        private ListAnalyzersResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalyzersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnalyzersResponse nextPage(ListAnalyzersResponse previousPage) {
            if (previousPage == null) {
                return ListAnalyzersIterable.this.client.listAnalyzers(ListAnalyzersIterable.this.firstRequest);
            }
            return ListAnalyzersIterable.this.client.listAnalyzers((ListAnalyzersRequest)((Object)ListAnalyzersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

