/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingRecommendationRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingRecommendationResponse;
import software.amazon.awssdk.services.accessanalyzer.model.RecommendedStep;

public class GetFindingRecommendationPublisher
implements SdkPublisher<GetFindingRecommendationResponse> {
    private final AccessAnalyzerAsyncClient client;
    private final GetFindingRecommendationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFindingRecommendationPublisher(AccessAnalyzerAsyncClient client, GetFindingRecommendationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFindingRecommendationPublisher(AccessAnalyzerAsyncClient client, GetFindingRecommendationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFindingRecommendationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFindingRecommendationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommendedStep> recommendedSteps() {
        Function<GetFindingRecommendationResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendedSteps() != null) {
                return response.recommendedSteps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetFindingRecommendationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetFindingRecommendationResponseFetcher
    implements AsyncPageFetcher<GetFindingRecommendationResponse> {
        private GetFindingRecommendationResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingRecommendationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFindingRecommendationResponse> nextPage(GetFindingRecommendationResponse previousPage) {
            if (previousPage == null) {
                return GetFindingRecommendationPublisher.this.client.getFindingRecommendation(GetFindingRecommendationPublisher.this.firstRequest);
            }
            return GetFindingRecommendationPublisher.this.client.getFindingRecommendation((GetFindingRecommendationRequest)((Object)GetFindingRecommendationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

