/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.Criterion;
import software.amazon.awssdk.services.accessanalyzer.model.FilterCriteriaMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessPreviewFindingsRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, ListAccessPreviewFindingsRequest> {
    private static final SdkField<String> ACCESS_PREVIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPreviewId").getter(ListAccessPreviewFindingsRequest.getter(ListAccessPreviewFindingsRequest::accessPreviewId)).setter(ListAccessPreviewFindingsRequest.setter(Builder::accessPreviewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accessPreviewId").build()}).build();
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analyzerArn").getter(ListAccessPreviewFindingsRequest.getter(ListAccessPreviewFindingsRequest::analyzerArn)).setter(ListAccessPreviewFindingsRequest.setter(Builder::analyzerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()}).build();
    private static final SdkField<Map<String, Criterion>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("filter").getter(ListAccessPreviewFindingsRequest.getter(ListAccessPreviewFindingsRequest::filter)).setter(ListAccessPreviewFindingsRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Criterion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccessPreviewFindingsRequest.getter(ListAccessPreviewFindingsRequest::nextToken)).setter(ListAccessPreviewFindingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAccessPreviewFindingsRequest.getter(ListAccessPreviewFindingsRequest::maxResults)).setter(ListAccessPreviewFindingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_PREVIEW_ID_FIELD, ANALYZER_ARN_FIELD, FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accessPreviewId", ACCESS_PREVIEW_ID_FIELD);
            this.put("analyzerArn", ANALYZER_ARN_FIELD);
            this.put("filter", FILTER_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String accessPreviewId;
    private final String analyzerArn;
    private final Map<String, Criterion> filter;
    private final String nextToken;
    private final Integer maxResults;

    private ListAccessPreviewFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.accessPreviewId = builder.accessPreviewId;
        this.analyzerArn = builder.analyzerArn;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String accessPreviewId() {
        return this.accessPreviewId;
    }

    public final String analyzerArn() {
        return this.analyzerArn;
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructMap);
    }

    public final Map<String, Criterion> filter() {
        return this.filter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPreviewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPreviewFindingsRequest)) {
            return false;
        }
        ListAccessPreviewFindingsRequest other = (ListAccessPreviewFindingsRequest)((Object)obj);
        return Objects.equals(this.accessPreviewId(), other.accessPreviewId()) && Objects.equals(this.analyzerArn(), other.analyzerArn()) && this.hasFilter() == other.hasFilter() && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessPreviewFindingsRequest").add("AccessPreviewId", (Object)this.accessPreviewId()).add("AnalyzerArn", (Object)this.analyzerArn()).add("Filter", this.hasFilter() ? this.filter() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPreviewId": {
                return Optional.ofNullable(clazz.cast(this.accessPreviewId()));
            }
            case "analyzerArn": {
                return Optional.ofNullable(clazz.cast(this.analyzerArn()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPreviewFindingsRequest, T> g) {
        return obj -> g.apply((ListAccessPreviewFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String accessPreviewId;
        private String analyzerArn;
        private Map<String, Criterion> filter = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPreviewFindingsRequest model) {
            super(model);
            this.accessPreviewId(model.accessPreviewId);
            this.analyzerArn(model.analyzerArn);
            this.filter(model.filter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getAccessPreviewId() {
            return this.accessPreviewId;
        }

        public final void setAccessPreviewId(String accessPreviewId) {
            this.accessPreviewId = accessPreviewId;
        }

        @Override
        public final Builder accessPreviewId(String accessPreviewId) {
            this.accessPreviewId = accessPreviewId;
            return this;
        }

        public final String getAnalyzerArn() {
            return this.analyzerArn;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final Map<String, Criterion.Builder> getFilter() {
            Map<String, Criterion.Builder> result = FilterCriteriaMapCopier.copyToBuilder(this.filter);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFilter(Map<String, Criterion.BuilderImpl> filter) {
            this.filter = FilterCriteriaMapCopier.copyFromBuilder(filter);
        }

        @Override
        public final Builder filter(Map<String, Criterion> filter) {
            this.filter = FilterCriteriaMapCopier.copy(filter);
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccessPreviewFindingsRequest build() {
            return new ListAccessPreviewFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessPreviewFindingsRequest> {
        public Builder accessPreviewId(String var1);

        public Builder analyzerArn(String var1);

        public Builder filter(Map<String, Criterion> var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

