/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedAction;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnusedPermissionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnusedPermissionDetails> {
    private static final SdkField<List<UnusedAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(UnusedPermissionDetails.getter(UnusedPermissionDetails::actions)).setter(UnusedPermissionDetails.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnusedAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNamespace").getter(UnusedPermissionDetails.getter(UnusedPermissionDetails::serviceNamespace)).setter(UnusedPermissionDetails.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNamespace").build()}).build();
    private static final SdkField<Instant> LAST_ACCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastAccessed").getter(UnusedPermissionDetails.getter(UnusedPermissionDetails::lastAccessed)).setter(UnusedPermissionDetails.setter(Builder::lastAccessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAccessed").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, SERVICE_NAMESPACE_FIELD, LAST_ACCESSED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actions", ACTIONS_FIELD);
            this.put("serviceNamespace", SERVICE_NAMESPACE_FIELD);
            this.put("lastAccessed", LAST_ACCESSED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<UnusedAction> actions;
    private final String serviceNamespace;
    private final Instant lastAccessed;

    private UnusedPermissionDetails(BuilderImpl builder) {
        this.actions = builder.actions;
        this.serviceNamespace = builder.serviceNamespace;
        this.lastAccessed = builder.lastAccessed;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<UnusedAction> actions() {
        return this.actions;
    }

    public final String serviceNamespace() {
        return this.serviceNamespace;
    }

    public final Instant lastAccessed() {
        return this.lastAccessed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedPermissionDetails)) {
            return false;
        }
        UnusedPermissionDetails other = (UnusedPermissionDetails)obj;
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.serviceNamespace(), other.serviceNamespace()) && Objects.equals(this.lastAccessed(), other.lastAccessed());
    }

    public final String toString() {
        return ToString.builder((String)"UnusedPermissionDetails").add("Actions", this.hasActions() ? this.actions() : null).add("ServiceNamespace", (Object)this.serviceNamespace()).add("LastAccessed", (Object)this.lastAccessed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "serviceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespace()));
            }
            case "lastAccessed": {
                return Optional.ofNullable(clazz.cast(this.lastAccessed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UnusedPermissionDetails, T> g) {
        return obj -> g.apply((UnusedPermissionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<UnusedAction> actions = DefaultSdkAutoConstructList.getInstance();
        private String serviceNamespace;
        private Instant lastAccessed;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedPermissionDetails model) {
            this.actions(model.actions);
            this.serviceNamespace(model.serviceNamespace);
            this.lastAccessed(model.lastAccessed);
        }

        public final List<UnusedAction.Builder> getActions() {
            List<UnusedAction.Builder> result = UnusedActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<UnusedAction.BuilderImpl> actions) {
            this.actions = UnusedActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<UnusedAction> actions) {
            this.actions = UnusedActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(UnusedAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<UnusedAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (UnusedAction)((UnusedAction.Builder)UnusedAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final Instant getLastAccessed() {
            return this.lastAccessed;
        }

        public final void setLastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        @Override
        public final Builder lastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
            return this;
        }

        public UnusedPermissionDetails build() {
            return new UnusedPermissionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnusedPermissionDetails> {
        public Builder actions(Collection<UnusedAction> var1);

        public Builder actions(UnusedAction ... var1);

        public Builder actions(Consumer<UnusedAction.Builder> ... var1);

        public Builder serviceNamespace(String var1);

        public Builder lastAccessed(Instant var1);
    }
}

