/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSummaryV2;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsV2Request;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsV2Response;

public class ListFindingsV2Iterable
implements SdkIterable<ListFindingsV2Response> {
    private final AccessAnalyzerClient client;
    private final ListFindingsV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFindingsV2Iterable(AccessAnalyzerClient client, ListFindingsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFindingsV2ResponseFetcher();
    }

    public Iterator<ListFindingsV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FindingSummaryV2> findings() {
        Function<ListFindingsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFindingsV2ResponseFetcher
    implements SyncPageFetcher<ListFindingsV2Response> {
        private ListFindingsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFindingsV2Response nextPage(ListFindingsV2Response previousPage) {
            if (previousPage == null) {
                return ListFindingsV2Iterable.this.client.listFindingsV2(ListFindingsV2Iterable.this.firstRequest);
            }
            return ListFindingsV2Iterable.this.client.listFindingsV2((ListFindingsV2Request)((Object)ListFindingsV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

