/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.ActionListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ConditionKeyMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSource;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSourceListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingStatus;
import software.amazon.awssdk.services.accessanalyzer.model.PrincipalMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceControlPolicyRestriction;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessPreviewFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessPreviewFinding> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AccessPreviewFinding.getter(AccessPreviewFinding::id)).setter(AccessPreviewFinding.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> EXISTING_FINDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("existingFindingId").getter(AccessPreviewFinding.getter(AccessPreviewFinding::existingFindingId)).setter(AccessPreviewFinding.setter(Builder::existingFindingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingFindingId").build()}).build();
    private static final SdkField<String> EXISTING_FINDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("existingFindingStatus").getter(AccessPreviewFinding.getter(AccessPreviewFinding::existingFindingStatusAsString)).setter(AccessPreviewFinding.setter(Builder::existingFindingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingFindingStatus").build()}).build();
    private static final SdkField<Map<String, String>> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("principal").getter(AccessPreviewFinding.getter(AccessPreviewFinding::principal)).setter(AccessPreviewFinding.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("action").getter(AccessPreviewFinding.getter(AccessPreviewFinding::action)).setter(AccessPreviewFinding.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("condition").getter(AccessPreviewFinding.getter(AccessPreviewFinding::condition)).setter(AccessPreviewFinding.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(AccessPreviewFinding.getter(AccessPreviewFinding::resource)).setter(AccessPreviewFinding.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPublic").getter(AccessPreviewFinding.getter(AccessPreviewFinding::isPublic)).setter(AccessPreviewFinding.setter(Builder::isPublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(AccessPreviewFinding.getter(AccessPreviewFinding::resourceTypeAsString)).setter(AccessPreviewFinding.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AccessPreviewFinding.getter(AccessPreviewFinding::createdAt)).setter(AccessPreviewFinding.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changeType").getter(AccessPreviewFinding.getter(AccessPreviewFinding::changeTypeAsString)).setter(AccessPreviewFinding.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AccessPreviewFinding.getter(AccessPreviewFinding::statusAsString)).setter(AccessPreviewFinding.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOwnerAccount").getter(AccessPreviewFinding.getter(AccessPreviewFinding::resourceOwnerAccount)).setter(AccessPreviewFinding.setter(Builder::resourceOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(AccessPreviewFinding.getter(AccessPreviewFinding::error)).setter(AccessPreviewFinding.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<List<FindingSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(AccessPreviewFinding.getter(AccessPreviewFinding::sources)).setter(AccessPreviewFinding.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceControlPolicyRestriction").getter(AccessPreviewFinding.getter(AccessPreviewFinding::resourceControlPolicyRestrictionAsString)).setter(AccessPreviewFinding.setter(Builder::resourceControlPolicyRestriction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceControlPolicyRestriction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXISTING_FINDING_ID_FIELD, EXISTING_FINDING_STATUS_FIELD, PRINCIPAL_FIELD, ACTION_FIELD, CONDITION_FIELD, RESOURCE_FIELD, IS_PUBLIC_FIELD, RESOURCE_TYPE_FIELD, CREATED_AT_FIELD, CHANGE_TYPE_FIELD, STATUS_FIELD, RESOURCE_OWNER_ACCOUNT_FIELD, ERROR_FIELD, SOURCES_FIELD, RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessPreviewFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String existingFindingId;
    private final String existingFindingStatus;
    private final Map<String, String> principal;
    private final List<String> action;
    private final Map<String, String> condition;
    private final String resource;
    private final Boolean isPublic;
    private final String resourceType;
    private final Instant createdAt;
    private final String changeType;
    private final String status;
    private final String resourceOwnerAccount;
    private final String error;
    private final List<FindingSource> sources;
    private final String resourceControlPolicyRestriction;

    private AccessPreviewFinding(BuilderImpl builder) {
        this.id = builder.id;
        this.existingFindingId = builder.existingFindingId;
        this.existingFindingStatus = builder.existingFindingStatus;
        this.principal = builder.principal;
        this.action = builder.action;
        this.condition = builder.condition;
        this.resource = builder.resource;
        this.isPublic = builder.isPublic;
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.changeType = builder.changeType;
        this.status = builder.status;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.error = builder.error;
        this.sources = builder.sources;
        this.resourceControlPolicyRestriction = builder.resourceControlPolicyRestriction;
    }

    public final String id() {
        return this.id;
    }

    public final String existingFindingId() {
        return this.existingFindingId;
    }

    public final FindingStatus existingFindingStatus() {
        return FindingStatus.fromValue(this.existingFindingStatus);
    }

    public final String existingFindingStatusAsString() {
        return this.existingFindingStatus;
    }

    public final boolean hasPrincipal() {
        return this.principal != null && !(this.principal instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> principal() {
        return this.principal;
    }

    public final boolean hasAction() {
        return this.action != null && !(this.action instanceof SdkAutoConstructList);
    }

    public final List<String> action() {
        return this.action;
    }

    public final boolean hasCondition() {
        return this.condition != null && !(this.condition instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> condition() {
        return this.condition;
    }

    public final String resource() {
        return this.resource;
    }

    public final Boolean isPublic() {
        return this.isPublic;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final FindingChangeType changeType() {
        return FindingChangeType.fromValue(this.changeType);
    }

    public final String changeTypeAsString() {
        return this.changeType;
    }

    public final FindingStatus status() {
        return FindingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String resourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public final String error() {
        return this.error;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<FindingSource> sources() {
        return this.sources;
    }

    public final ResourceControlPolicyRestriction resourceControlPolicyRestriction() {
        return ResourceControlPolicyRestriction.fromValue(this.resourceControlPolicyRestriction);
    }

    public final String resourceControlPolicyRestrictionAsString() {
        return this.resourceControlPolicyRestriction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingFindingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingFindingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipal() ? this.principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAction() ? this.action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCondition() ? this.condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceControlPolicyRestrictionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPreviewFinding)) {
            return false;
        }
        AccessPreviewFinding other = (AccessPreviewFinding)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.existingFindingId(), other.existingFindingId()) && Objects.equals(this.existingFindingStatusAsString(), other.existingFindingStatusAsString()) && this.hasPrincipal() == other.hasPrincipal() && Objects.equals(this.principal(), other.principal()) && this.hasAction() == other.hasAction() && Objects.equals(this.action(), other.action()) && this.hasCondition() == other.hasCondition() && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.isPublic(), other.isPublic()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.changeTypeAsString(), other.changeTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resourceOwnerAccount(), other.resourceOwnerAccount()) && Objects.equals(this.error(), other.error()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.resourceControlPolicyRestrictionAsString(), other.resourceControlPolicyRestrictionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccessPreviewFinding").add("Id", (Object)this.id()).add("ExistingFindingId", (Object)this.existingFindingId()).add("ExistingFindingStatus", (Object)this.existingFindingStatusAsString()).add("Principal", this.hasPrincipal() ? this.principal() : null).add("Action", this.hasAction() ? this.action() : null).add("Condition", this.hasCondition() ? this.condition() : null).add("Resource", (Object)this.resource()).add("IsPublic", (Object)this.isPublic()).add("ResourceType", (Object)this.resourceTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("ChangeType", (Object)this.changeTypeAsString()).add("Status", (Object)this.statusAsString()).add("ResourceOwnerAccount", (Object)this.resourceOwnerAccount()).add("Error", (Object)this.error()).add("Sources", this.hasSources() ? this.sources() : null).add("ResourceControlPolicyRestriction", (Object)this.resourceControlPolicyRestrictionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "existingFindingId": {
                return Optional.ofNullable(clazz.cast(this.existingFindingId()));
            }
            case "existingFindingStatus": {
                return Optional.ofNullable(clazz.cast(this.existingFindingStatusAsString()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "isPublic": {
                return Optional.ofNullable(clazz.cast(this.isPublic()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "changeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "resourceOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAccount()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "resourceControlPolicyRestriction": {
                return Optional.ofNullable(clazz.cast(this.resourceControlPolicyRestrictionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("existingFindingId", EXISTING_FINDING_ID_FIELD);
        map.put("existingFindingStatus", EXISTING_FINDING_STATUS_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("condition", CONDITION_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("isPublic", IS_PUBLIC_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("changeType", CHANGE_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resourceOwnerAccount", RESOURCE_OWNER_ACCOUNT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("resourceControlPolicyRestriction", RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessPreviewFinding, T> g) {
        return obj -> g.apply((AccessPreviewFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String existingFindingId;
        private String existingFindingStatus;
        private Map<String, String> principal = DefaultSdkAutoConstructMap.getInstance();
        private List<String> action = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> condition = DefaultSdkAutoConstructMap.getInstance();
        private String resource;
        private Boolean isPublic;
        private String resourceType;
        private Instant createdAt;
        private String changeType;
        private String status;
        private String resourceOwnerAccount;
        private String error;
        private List<FindingSource> sources = DefaultSdkAutoConstructList.getInstance();
        private String resourceControlPolicyRestriction;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPreviewFinding model) {
            this.id(model.id);
            this.existingFindingId(model.existingFindingId);
            this.existingFindingStatus(model.existingFindingStatus);
            this.principal(model.principal);
            this.action(model.action);
            this.condition(model.condition);
            this.resource(model.resource);
            this.isPublic(model.isPublic);
            this.resourceType(model.resourceType);
            this.createdAt(model.createdAt);
            this.changeType(model.changeType);
            this.status(model.status);
            this.resourceOwnerAccount(model.resourceOwnerAccount);
            this.error(model.error);
            this.sources(model.sources);
            this.resourceControlPolicyRestriction(model.resourceControlPolicyRestriction);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExistingFindingId() {
            return this.existingFindingId;
        }

        public final void setExistingFindingId(String existingFindingId) {
            this.existingFindingId = existingFindingId;
        }

        @Override
        public final Builder existingFindingId(String existingFindingId) {
            this.existingFindingId = existingFindingId;
            return this;
        }

        public final String getExistingFindingStatus() {
            return this.existingFindingStatus;
        }

        public final void setExistingFindingStatus(String existingFindingStatus) {
            this.existingFindingStatus = existingFindingStatus;
        }

        @Override
        public final Builder existingFindingStatus(String existingFindingStatus) {
            this.existingFindingStatus = existingFindingStatus;
            return this;
        }

        @Override
        public final Builder existingFindingStatus(FindingStatus existingFindingStatus) {
            this.existingFindingStatus(existingFindingStatus == null ? null : existingFindingStatus.toString());
            return this;
        }

        public final Map<String, String> getPrincipal() {
            if (this.principal instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.principal;
        }

        public final void setPrincipal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
        }

        @Override
        public final Builder principal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
            return this;
        }

        public final Collection<String> getAction() {
            if (this.action instanceof SdkAutoConstructList) {
                return null;
            }
            return this.action;
        }

        public final void setAction(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String ... action) {
            this.action(Arrays.asList(action));
            return this;
        }

        public final Map<String, String> getCondition() {
            if (this.condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.condition;
        }

        public final void setCondition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
        }

        @Override
        public final Builder condition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final Boolean getIsPublic() {
            return this.isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getChangeType() {
            return this.changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(FindingChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getResourceOwnerAccount() {
            return this.resourceOwnerAccount;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final List<FindingSource.Builder> getSources() {
            List<FindingSource.Builder> result = FindingSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<FindingSource.BuilderImpl> sources) {
            this.sources = FindingSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<FindingSource> sources) {
            this.sources = FindingSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(FindingSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<FindingSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (FindingSource)((FindingSource.Builder)FindingSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceControlPolicyRestriction() {
            return this.resourceControlPolicyRestriction;
        }

        public final void setResourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
            return this;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction(resourceControlPolicyRestriction == null ? null : resourceControlPolicyRestriction.toString());
            return this;
        }

        public AccessPreviewFinding build() {
            return new AccessPreviewFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessPreviewFinding> {
        public Builder id(String var1);

        public Builder existingFindingId(String var1);

        public Builder existingFindingStatus(String var1);

        public Builder existingFindingStatus(FindingStatus var1);

        public Builder principal(Map<String, String> var1);

        public Builder action(Collection<String> var1);

        public Builder action(String ... var1);

        public Builder condition(Map<String, String> var1);

        public Builder resource(String var1);

        public Builder isPublic(Boolean var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder createdAt(Instant var1);

        public Builder changeType(String var1);

        public Builder changeType(FindingChangeType var1);

        public Builder status(String var1);

        public Builder status(FindingStatus var1);

        public Builder resourceOwnerAccount(String var1);

        public Builder error(String var1);

        public Builder sources(Collection<FindingSource> var1);

        public Builder sources(FindingSource ... var1);

        public Builder sources(Consumer<FindingSource.Builder> ... var1);

        public Builder resourceControlPolicyRestriction(String var1);

        public Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction var1);
    }
}

