/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KmsGrantOperation {
    CREATE_GRANT("CreateGrant"),
    DECRYPT("Decrypt"),
    DESCRIBE_KEY("DescribeKey"),
    ENCRYPT("Encrypt"),
    GENERATE_DATA_KEY("GenerateDataKey"),
    GENERATE_DATA_KEY_PAIR("GenerateDataKeyPair"),
    GENERATE_DATA_KEY_PAIR_WITHOUT_PLAINTEXT("GenerateDataKeyPairWithoutPlaintext"),
    GENERATE_DATA_KEY_WITHOUT_PLAINTEXT("GenerateDataKeyWithoutPlaintext"),
    GET_PUBLIC_KEY("GetPublicKey"),
    RE_ENCRYPT_FROM("ReEncryptFrom"),
    RE_ENCRYPT_TO("ReEncryptTo"),
    RETIRE_GRANT("RetireGrant"),
    SIGN("Sign"),
    VERIFY("Verify"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KmsGrantOperation> VALUE_MAP;
    private final String value;

    private KmsGrantOperation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KmsGrantOperation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KmsGrantOperation> knownValues() {
        EnumSet<KmsGrantOperation> knownValues = EnumSet.allOf(KmsGrantOperation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KmsGrantOperation.class, KmsGrantOperation::toString);
    }
}

