/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FindingChangeType {
    CHANGED("CHANGED"),
    NEW("NEW"),
    UNCHANGED("UNCHANGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FindingChangeType> VALUE_MAP;
    private final String value;

    private FindingChangeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FindingChangeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FindingChangeType> knownValues() {
        EnumSet<FindingChangeType> knownValues = EnumSet.allOf(FindingChangeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FindingChangeType.class, FindingChangeType::toString);
    }
}

