/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acmpca.model.PolicyQualifierInfo;
import software.amazon.awssdk.services.acmpca.model.PolicyQualifierInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyInformation> {
    private static final SdkField<String> CERT_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertPolicyId").getter(PolicyInformation.getter(PolicyInformation::certPolicyId)).setter(PolicyInformation.setter(Builder::certPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertPolicyId").build()}).build();
    private static final SdkField<List<PolicyQualifierInfo>> POLICY_QUALIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyQualifiers").getter(PolicyInformation.getter(PolicyInformation::policyQualifiers)).setter(PolicyInformation.setter(Builder::policyQualifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyQualifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyQualifierInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERT_POLICY_ID_FIELD, POLICY_QUALIFIERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certPolicyId;
    private final List<PolicyQualifierInfo> policyQualifiers;

    private PolicyInformation(BuilderImpl builder) {
        this.certPolicyId = builder.certPolicyId;
        this.policyQualifiers = builder.policyQualifiers;
    }

    public final String certPolicyId() {
        return this.certPolicyId;
    }

    public final boolean hasPolicyQualifiers() {
        return this.policyQualifiers != null && !(this.policyQualifiers instanceof SdkAutoConstructList);
    }

    public final List<PolicyQualifierInfo> policyQualifiers() {
        return this.policyQualifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyQualifiers() ? this.policyQualifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyInformation)) {
            return false;
        }
        PolicyInformation other = (PolicyInformation)obj;
        return Objects.equals(this.certPolicyId(), other.certPolicyId()) && this.hasPolicyQualifiers() == other.hasPolicyQualifiers() && Objects.equals(this.policyQualifiers(), other.policyQualifiers());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyInformation").add("CertPolicyId", (Object)this.certPolicyId()).add("PolicyQualifiers", this.hasPolicyQualifiers() ? this.policyQualifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertPolicyId": {
                return Optional.ofNullable(clazz.cast(this.certPolicyId()));
            }
            case "PolicyQualifiers": {
                return Optional.ofNullable(clazz.cast(this.policyQualifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyInformation, T> g) {
        return obj -> g.apply((PolicyInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certPolicyId;
        private List<PolicyQualifierInfo> policyQualifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyInformation model) {
            this.certPolicyId(model.certPolicyId);
            this.policyQualifiers(model.policyQualifiers);
        }

        public final String getCertPolicyId() {
            return this.certPolicyId;
        }

        public final void setCertPolicyId(String certPolicyId) {
            this.certPolicyId = certPolicyId;
        }

        @Override
        public final Builder certPolicyId(String certPolicyId) {
            this.certPolicyId = certPolicyId;
            return this;
        }

        public final List<PolicyQualifierInfo.Builder> getPolicyQualifiers() {
            List<PolicyQualifierInfo.Builder> result = PolicyQualifierInfoListCopier.copyToBuilder(this.policyQualifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyQualifiers(Collection<PolicyQualifierInfo.BuilderImpl> policyQualifiers) {
            this.policyQualifiers = PolicyQualifierInfoListCopier.copyFromBuilder(policyQualifiers);
        }

        @Override
        public final Builder policyQualifiers(Collection<PolicyQualifierInfo> policyQualifiers) {
            this.policyQualifiers = PolicyQualifierInfoListCopier.copy(policyQualifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyQualifiers(PolicyQualifierInfo ... policyQualifiers) {
            this.policyQualifiers(Arrays.asList(policyQualifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyQualifiers(Consumer<PolicyQualifierInfo.Builder> ... policyQualifiers) {
            this.policyQualifiers(Stream.of(policyQualifiers).map(c -> (PolicyQualifierInfo)((PolicyQualifierInfo.Builder)PolicyQualifierInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PolicyInformation build() {
            return new PolicyInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyInformation> {
        public Builder certPolicyId(String var1);

        public Builder policyQualifiers(Collection<PolicyQualifierInfo> var1);

        public Builder policyQualifiers(PolicyQualifierInfo ... var1);

        public Builder policyQualifiers(Consumer<PolicyQualifierInfo.Builder> ... var1);
    }
}

