/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateMeetingRoomConfiguration;
import software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.WakeWord;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProfileRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, CreateProfileRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProfileRequest.getter(CreateProfileRequest::profileName)).setter(CreateProfileRequest.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProfileRequest.getter(CreateProfileRequest::timezone)).setter(CreateProfileRequest.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProfileRequest.getter(CreateProfileRequest::address)).setter(CreateProfileRequest.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProfileRequest.getter(CreateProfileRequest::distanceUnitAsString)).setter(CreateProfileRequest.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final SdkField<String> TEMPERATURE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProfileRequest.getter(CreateProfileRequest::temperatureUnitAsString)).setter(CreateProfileRequest.setter(Builder::temperatureUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemperatureUnit").build()}).build();
    private static final SdkField<String> WAKE_WORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProfileRequest.getter(CreateProfileRequest::wakeWordAsString)).setter(CreateProfileRequest.setter(Builder::wakeWord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WakeWord").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProfileRequest.getter(CreateProfileRequest::locale)).setter(CreateProfileRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProfileRequest.getter(CreateProfileRequest::clientRequestToken)).setter(CreateProfileRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> SETUP_MODE_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateProfileRequest.getter(CreateProfileRequest::setupModeDisabled)).setter(CreateProfileRequest.setter(Builder::setupModeDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetupModeDisabled").build()}).build();
    private static final SdkField<Integer> MAX_VOLUME_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateProfileRequest.getter(CreateProfileRequest::maxVolumeLimit)).setter(CreateProfileRequest.setter(Builder::maxVolumeLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxVolumeLimit").build()}).build();
    private static final SdkField<Boolean> PSTN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateProfileRequest.getter(CreateProfileRequest::pstnEnabled)).setter(CreateProfileRequest.setter(Builder::pstnEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PSTNEnabled").build()}).build();
    private static final SdkField<CreateMeetingRoomConfiguration> MEETING_ROOM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateProfileRequest.getter(CreateProfileRequest::meetingRoomConfiguration)).setter(CreateProfileRequest.setter(Builder::meetingRoomConfiguration)).constructor(CreateMeetingRoomConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingRoomConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, TIMEZONE_FIELD, ADDRESS_FIELD, DISTANCE_UNIT_FIELD, TEMPERATURE_UNIT_FIELD, WAKE_WORD_FIELD, LOCALE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, SETUP_MODE_DISABLED_FIELD, MAX_VOLUME_LIMIT_FIELD, PSTN_ENABLED_FIELD, MEETING_ROOM_CONFIGURATION_FIELD));
    private final String profileName;
    private final String timezone;
    private final String address;
    private final String distanceUnit;
    private final String temperatureUnit;
    private final String wakeWord;
    private final String locale;
    private final String clientRequestToken;
    private final Boolean setupModeDisabled;
    private final Integer maxVolumeLimit;
    private final Boolean pstnEnabled;
    private final CreateMeetingRoomConfiguration meetingRoomConfiguration;

    private CreateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.timezone = builder.timezone;
        this.address = builder.address;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
        this.locale = builder.locale;
        this.clientRequestToken = builder.clientRequestToken;
        this.setupModeDisabled = builder.setupModeDisabled;
        this.maxVolumeLimit = builder.maxVolumeLimit;
        this.pstnEnabled = builder.pstnEnabled;
        this.meetingRoomConfiguration = builder.meetingRoomConfiguration;
    }

    public String profileName() {
        return this.profileName;
    }

    public String timezone() {
        return this.timezone;
    }

    public String address() {
        return this.address;
    }

    public DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(this.temperatureUnit);
    }

    public String temperatureUnitAsString() {
        return this.temperatureUnit;
    }

    public WakeWord wakeWord() {
        return WakeWord.fromValue(this.wakeWord);
    }

    public String wakeWordAsString() {
        return this.wakeWord;
    }

    public String locale() {
        return this.locale;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public Boolean setupModeDisabled() {
        return this.setupModeDisabled;
    }

    public Integer maxVolumeLimit() {
        return this.maxVolumeLimit;
    }

    public Boolean pstnEnabled() {
        return this.pstnEnabled;
    }

    public CreateMeetingRoomConfiguration meetingRoomConfiguration() {
        return this.meetingRoomConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temperatureUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wakeWordAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.setupModeDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxVolumeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.pstnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingRoomConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileRequest)) {
            return false;
        }
        CreateProfileRequest other = (CreateProfileRequest)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.temperatureUnitAsString(), other.temperatureUnitAsString()) && Objects.equals(this.wakeWordAsString(), other.wakeWordAsString()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.setupModeDisabled(), other.setupModeDisabled()) && Objects.equals(this.maxVolumeLimit(), other.maxVolumeLimit()) && Objects.equals(this.pstnEnabled(), other.pstnEnabled()) && Objects.equals(this.meetingRoomConfiguration(), other.meetingRoomConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"CreateProfileRequest").add("ProfileName", (Object)this.profileName()).add("Timezone", (Object)this.timezone()).add("Address", (Object)this.address()).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("TemperatureUnit", (Object)this.temperatureUnitAsString()).add("WakeWord", (Object)this.wakeWordAsString()).add("Locale", (Object)this.locale()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("SetupModeDisabled", (Object)this.setupModeDisabled()).add("MaxVolumeLimit", (Object)this.maxVolumeLimit()).add("PSTNEnabled", (Object)this.pstnEnabled()).add("MeetingRoomConfiguration", (Object)this.meetingRoomConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "TemperatureUnit": {
                return Optional.ofNullable(clazz.cast(this.temperatureUnitAsString()));
            }
            case "WakeWord": {
                return Optional.ofNullable(clazz.cast(this.wakeWordAsString()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "SetupModeDisabled": {
                return Optional.ofNullable(clazz.cast(this.setupModeDisabled()));
            }
            case "MaxVolumeLimit": {
                return Optional.ofNullable(clazz.cast(this.maxVolumeLimit()));
            }
            case "PSTNEnabled": {
                return Optional.ofNullable(clazz.cast(this.pstnEnabled()));
            }
            case "MeetingRoomConfiguration": {
                return Optional.ofNullable(clazz.cast(this.meetingRoomConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProfileRequest, T> g) {
        return obj -> g.apply((CreateProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String profileName;
        private String timezone;
        private String address;
        private String distanceUnit;
        private String temperatureUnit;
        private String wakeWord;
        private String locale;
        private String clientRequestToken;
        private Boolean setupModeDisabled;
        private Integer maxVolumeLimit;
        private Boolean pstnEnabled;
        private CreateMeetingRoomConfiguration meetingRoomConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileRequest model) {
            super(model);
            this.profileName(model.profileName);
            this.timezone(model.timezone);
            this.address(model.address);
            this.distanceUnit(model.distanceUnit);
            this.temperatureUnit(model.temperatureUnit);
            this.wakeWord(model.wakeWord);
            this.locale(model.locale);
            this.clientRequestToken(model.clientRequestToken);
            this.setupModeDisabled(model.setupModeDisabled);
            this.maxVolumeLimit(model.maxVolumeLimit);
            this.pstnEnabled(model.pstnEnabled);
            this.meetingRoomConfiguration(model.meetingRoomConfiguration);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getDistanceUnitAsString() {
            return this.distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        public final String getTemperatureUnitAsString() {
            return this.temperatureUnit;
        }

        @Override
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit == null ? null : temperatureUnit.toString());
            return this;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        public final String getWakeWordAsString() {
            return this.wakeWord;
        }

        @Override
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord == null ? null : wakeWord.toString());
            return this;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Boolean getSetupModeDisabled() {
            return this.setupModeDisabled;
        }

        @Override
        public final Builder setupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
            return this;
        }

        public final void setSetupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
        }

        public final Integer getMaxVolumeLimit() {
            return this.maxVolumeLimit;
        }

        @Override
        public final Builder maxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
            return this;
        }

        public final void setMaxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
        }

        public final Boolean getPstnEnabled() {
            return this.pstnEnabled;
        }

        @Override
        public final Builder pstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
            return this;
        }

        public final void setPstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
        }

        public final CreateMeetingRoomConfiguration.Builder getMeetingRoomConfiguration() {
            return this.meetingRoomConfiguration != null ? this.meetingRoomConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder meetingRoomConfiguration(CreateMeetingRoomConfiguration meetingRoomConfiguration) {
            this.meetingRoomConfiguration = meetingRoomConfiguration;
            return this;
        }

        public final void setMeetingRoomConfiguration(CreateMeetingRoomConfiguration.BuilderImpl meetingRoomConfiguration) {
            this.meetingRoomConfiguration = meetingRoomConfiguration != null ? meetingRoomConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfileRequest build() {
            return new CreateProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProfileRequest> {
        public Builder profileName(String var1);

        public Builder timezone(String var1);

        public Builder address(String var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder temperatureUnit(String var1);

        public Builder temperatureUnit(TemperatureUnit var1);

        public Builder wakeWord(String var1);

        public Builder wakeWord(WakeWord var1);

        public Builder locale(String var1);

        public Builder clientRequestToken(String var1);

        public Builder setupModeDisabled(Boolean var1);

        public Builder maxVolumeLimit(Integer var1);

        public Builder pstnEnabled(Boolean var1);

        public Builder meetingRoomConfiguration(CreateMeetingRoomConfiguration var1);

        default public Builder meetingRoomConfiguration(Consumer<CreateMeetingRoomConfiguration.Builder> meetingRoomConfiguration) {
            return this.meetingRoomConfiguration((CreateMeetingRoomConfiguration)((CreateMeetingRoomConfiguration.Builder)CreateMeetingRoomConfiguration.builder().applyMutation(meetingRoomConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

