/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteBusinessReportScheduleRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, DeleteBusinessReportScheduleRequest> {
    private static final SdkField<String> SCHEDULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteBusinessReportScheduleRequest.getter(DeleteBusinessReportScheduleRequest::scheduleArn)).setter(DeleteBusinessReportScheduleRequest.setter(Builder::scheduleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_ARN_FIELD));
    private final String scheduleArn;

    private DeleteBusinessReportScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.scheduleArn = builder.scheduleArn;
    }

    public String scheduleArn() {
        return this.scheduleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBusinessReportScheduleRequest)) {
            return false;
        }
        DeleteBusinessReportScheduleRequest other = (DeleteBusinessReportScheduleRequest)((Object)obj);
        return Objects.equals(this.scheduleArn(), other.scheduleArn());
    }

    public String toString() {
        return ToString.builder((String)"DeleteBusinessReportScheduleRequest").add("ScheduleArn", (Object)this.scheduleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleArn": {
                return Optional.ofNullable(clazz.cast(this.scheduleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBusinessReportScheduleRequest, T> g) {
        return obj -> g.apply((DeleteBusinessReportScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String scheduleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBusinessReportScheduleRequest model) {
            super(model);
            this.scheduleArn(model.scheduleArn);
        }

        public final String getScheduleArn() {
            return this.scheduleArn;
        }

        @Override
        public final Builder scheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
            return this;
        }

        public final void setScheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBusinessReportScheduleRequest build() {
            return new DeleteBusinessReportScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteBusinessReportScheduleRequest> {
        public Builder scheduleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

