/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.alexaforbusiness.model.BulletPointsCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.DeveloperInfo;
import software.amazon.awssdk.services.alexaforbusiness.model.GenericKeywordsCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.NewInThisVersionBulletPointsCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.ReviewsCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SkillDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SkillDetails> {
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SkillDetails.getter(SkillDetails::productDescription)).setter(SkillDetails.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build()}).build();
    private static final SdkField<String> INVOCATION_PHRASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SkillDetails.getter(SkillDetails::invocationPhrase)).setter(SkillDetails.setter(Builder::invocationPhrase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationPhrase").build()}).build();
    private static final SdkField<String> RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SkillDetails.getter(SkillDetails::releaseDate)).setter(SkillDetails.setter(Builder::releaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()}).build();
    private static final SdkField<String> END_USER_LICENSE_AGREEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SkillDetails.getter(SkillDetails::endUserLicenseAgreement)).setter(SkillDetails.setter(Builder::endUserLicenseAgreement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndUserLicenseAgreement").build()}).build();
    private static final SdkField<List<String>> GENERIC_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SkillDetails.getter(SkillDetails::genericKeywords)).setter(SkillDetails.setter(Builder::genericKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenericKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BULLET_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SkillDetails.getter(SkillDetails::bulletPoints)).setter(SkillDetails.setter(Builder::bulletPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulletPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NEW_IN_THIS_VERSION_BULLET_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SkillDetails.getter(SkillDetails::newInThisVersionBulletPoints)).setter(SkillDetails.setter(Builder::newInThisVersionBulletPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInThisVersionBulletPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SKILL_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SkillDetails.getter(SkillDetails::skillTypes)).setter(SkillDetails.setter(Builder::skillTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REVIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SkillDetails.getter(SkillDetails::reviews)).setter(SkillDetails.setter(Builder::reviews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reviews").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DeveloperInfo> DEVELOPER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SkillDetails.getter(SkillDetails::developerInfo)).setter(SkillDetails.setter(Builder::developerInfo)).constructor(DeveloperInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_DESCRIPTION_FIELD, INVOCATION_PHRASE_FIELD, RELEASE_DATE_FIELD, END_USER_LICENSE_AGREEMENT_FIELD, GENERIC_KEYWORDS_FIELD, BULLET_POINTS_FIELD, NEW_IN_THIS_VERSION_BULLET_POINTS_FIELD, SKILL_TYPES_FIELD, REVIEWS_FIELD, DEVELOPER_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String productDescription;
    private final String invocationPhrase;
    private final String releaseDate;
    private final String endUserLicenseAgreement;
    private final List<String> genericKeywords;
    private final List<String> bulletPoints;
    private final List<String> newInThisVersionBulletPoints;
    private final List<String> skillTypes;
    private final Map<String, String> reviews;
    private final DeveloperInfo developerInfo;

    private SkillDetails(BuilderImpl builder) {
        this.productDescription = builder.productDescription;
        this.invocationPhrase = builder.invocationPhrase;
        this.releaseDate = builder.releaseDate;
        this.endUserLicenseAgreement = builder.endUserLicenseAgreement;
        this.genericKeywords = builder.genericKeywords;
        this.bulletPoints = builder.bulletPoints;
        this.newInThisVersionBulletPoints = builder.newInThisVersionBulletPoints;
        this.skillTypes = builder.skillTypes;
        this.reviews = builder.reviews;
        this.developerInfo = builder.developerInfo;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String invocationPhrase() {
        return this.invocationPhrase;
    }

    public String releaseDate() {
        return this.releaseDate;
    }

    public String endUserLicenseAgreement() {
        return this.endUserLicenseAgreement;
    }

    public boolean hasGenericKeywords() {
        return this.genericKeywords != null && !(this.genericKeywords instanceof SdkAutoConstructList);
    }

    public List<String> genericKeywords() {
        return this.genericKeywords;
    }

    public boolean hasBulletPoints() {
        return this.bulletPoints != null && !(this.bulletPoints instanceof SdkAutoConstructList);
    }

    public List<String> bulletPoints() {
        return this.bulletPoints;
    }

    public boolean hasNewInThisVersionBulletPoints() {
        return this.newInThisVersionBulletPoints != null && !(this.newInThisVersionBulletPoints instanceof SdkAutoConstructList);
    }

    public List<String> newInThisVersionBulletPoints() {
        return this.newInThisVersionBulletPoints;
    }

    public boolean hasSkillTypes() {
        return this.skillTypes != null && !(this.skillTypes instanceof SdkAutoConstructList);
    }

    public List<String> skillTypes() {
        return this.skillTypes;
    }

    public boolean hasReviews() {
        return this.reviews != null && !(this.reviews instanceof SdkAutoConstructMap);
    }

    public Map<String, String> reviews() {
        return this.reviews;
    }

    public DeveloperInfo developerInfo() {
        return this.developerInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationPhrase());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endUserLicenseAgreement());
        hashCode = 31 * hashCode + Objects.hashCode(this.genericKeywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.bulletPoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.newInThisVersionBulletPoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviews());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillDetails)) {
            return false;
        }
        SkillDetails other = (SkillDetails)obj;
        return Objects.equals(this.productDescription(), other.productDescription()) && Objects.equals(this.invocationPhrase(), other.invocationPhrase()) && Objects.equals(this.releaseDate(), other.releaseDate()) && Objects.equals(this.endUserLicenseAgreement(), other.endUserLicenseAgreement()) && Objects.equals(this.genericKeywords(), other.genericKeywords()) && Objects.equals(this.bulletPoints(), other.bulletPoints()) && Objects.equals(this.newInThisVersionBulletPoints(), other.newInThisVersionBulletPoints()) && Objects.equals(this.skillTypes(), other.skillTypes()) && Objects.equals(this.reviews(), other.reviews()) && Objects.equals(this.developerInfo(), other.developerInfo());
    }

    public String toString() {
        return ToString.builder((String)"SkillDetails").add("ProductDescription", (Object)this.productDescription()).add("InvocationPhrase", (Object)this.invocationPhrase()).add("ReleaseDate", (Object)this.releaseDate()).add("EndUserLicenseAgreement", (Object)this.endUserLicenseAgreement()).add("GenericKeywords", this.genericKeywords()).add("BulletPoints", this.bulletPoints()).add("NewInThisVersionBulletPoints", this.newInThisVersionBulletPoints()).add("SkillTypes", this.skillTypes()).add("Reviews", this.reviews()).add("DeveloperInfo", (Object)this.developerInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescription()));
            }
            case "InvocationPhrase": {
                return Optional.ofNullable(clazz.cast(this.invocationPhrase()));
            }
            case "ReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.releaseDate()));
            }
            case "EndUserLicenseAgreement": {
                return Optional.ofNullable(clazz.cast(this.endUserLicenseAgreement()));
            }
            case "GenericKeywords": {
                return Optional.ofNullable(clazz.cast(this.genericKeywords()));
            }
            case "BulletPoints": {
                return Optional.ofNullable(clazz.cast(this.bulletPoints()));
            }
            case "NewInThisVersionBulletPoints": {
                return Optional.ofNullable(clazz.cast(this.newInThisVersionBulletPoints()));
            }
            case "SkillTypes": {
                return Optional.ofNullable(clazz.cast(this.skillTypes()));
            }
            case "Reviews": {
                return Optional.ofNullable(clazz.cast(this.reviews()));
            }
            case "DeveloperInfo": {
                return Optional.ofNullable(clazz.cast(this.developerInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SkillDetails, T> g) {
        return obj -> g.apply((SkillDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productDescription;
        private String invocationPhrase;
        private String releaseDate;
        private String endUserLicenseAgreement;
        private List<String> genericKeywords = DefaultSdkAutoConstructList.getInstance();
        private List<String> bulletPoints = DefaultSdkAutoConstructList.getInstance();
        private List<String> newInThisVersionBulletPoints = DefaultSdkAutoConstructList.getInstance();
        private List<String> skillTypes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> reviews = DefaultSdkAutoConstructMap.getInstance();
        private DeveloperInfo developerInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillDetails model) {
            this.productDescription(model.productDescription);
            this.invocationPhrase(model.invocationPhrase);
            this.releaseDate(model.releaseDate);
            this.endUserLicenseAgreement(model.endUserLicenseAgreement);
            this.genericKeywords(model.genericKeywords);
            this.bulletPoints(model.bulletPoints);
            this.newInThisVersionBulletPoints(model.newInThisVersionBulletPoints);
            this.skillTypes(model.skillTypes);
            this.reviews(model.reviews);
            this.developerInfo(model.developerInfo);
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getInvocationPhrase() {
            return this.invocationPhrase;
        }

        @Override
        public final Builder invocationPhrase(String invocationPhrase) {
            this.invocationPhrase = invocationPhrase;
            return this;
        }

        public final void setInvocationPhrase(String invocationPhrase) {
            this.invocationPhrase = invocationPhrase;
        }

        public final String getReleaseDate() {
            return this.releaseDate;
        }

        @Override
        public final Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final void setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
        }

        public final String getEndUserLicenseAgreement() {
            return this.endUserLicenseAgreement;
        }

        @Override
        public final Builder endUserLicenseAgreement(String endUserLicenseAgreement) {
            this.endUserLicenseAgreement = endUserLicenseAgreement;
            return this;
        }

        public final void setEndUserLicenseAgreement(String endUserLicenseAgreement) {
            this.endUserLicenseAgreement = endUserLicenseAgreement;
        }

        public final Collection<String> getGenericKeywords() {
            return this.genericKeywords;
        }

        @Override
        public final Builder genericKeywords(Collection<String> genericKeywords) {
            this.genericKeywords = GenericKeywordsCopier.copy(genericKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder genericKeywords(String ... genericKeywords) {
            this.genericKeywords(Arrays.asList(genericKeywords));
            return this;
        }

        public final void setGenericKeywords(Collection<String> genericKeywords) {
            this.genericKeywords = GenericKeywordsCopier.copy(genericKeywords);
        }

        public final Collection<String> getBulletPoints() {
            return this.bulletPoints;
        }

        @Override
        public final Builder bulletPoints(Collection<String> bulletPoints) {
            this.bulletPoints = BulletPointsCopier.copy(bulletPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulletPoints(String ... bulletPoints) {
            this.bulletPoints(Arrays.asList(bulletPoints));
            return this;
        }

        public final void setBulletPoints(Collection<String> bulletPoints) {
            this.bulletPoints = BulletPointsCopier.copy(bulletPoints);
        }

        public final Collection<String> getNewInThisVersionBulletPoints() {
            return this.newInThisVersionBulletPoints;
        }

        @Override
        public final Builder newInThisVersionBulletPoints(Collection<String> newInThisVersionBulletPoints) {
            this.newInThisVersionBulletPoints = NewInThisVersionBulletPointsCopier.copy(newInThisVersionBulletPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newInThisVersionBulletPoints(String ... newInThisVersionBulletPoints) {
            this.newInThisVersionBulletPoints(Arrays.asList(newInThisVersionBulletPoints));
            return this;
        }

        public final void setNewInThisVersionBulletPoints(Collection<String> newInThisVersionBulletPoints) {
            this.newInThisVersionBulletPoints = NewInThisVersionBulletPointsCopier.copy(newInThisVersionBulletPoints);
        }

        public final Collection<String> getSkillTypes() {
            return this.skillTypes;
        }

        @Override
        public final Builder skillTypes(Collection<String> skillTypes) {
            this.skillTypes = SkillTypesCopier.copy(skillTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillTypes(String ... skillTypes) {
            this.skillTypes(Arrays.asList(skillTypes));
            return this;
        }

        public final void setSkillTypes(Collection<String> skillTypes) {
            this.skillTypes = SkillTypesCopier.copy(skillTypes);
        }

        public final Map<String, String> getReviews() {
            return this.reviews;
        }

        @Override
        public final Builder reviews(Map<String, String> reviews) {
            this.reviews = ReviewsCopier.copy(reviews);
            return this;
        }

        public final void setReviews(Map<String, String> reviews) {
            this.reviews = ReviewsCopier.copy(reviews);
        }

        public final DeveloperInfo.Builder getDeveloperInfo() {
            return this.developerInfo != null ? this.developerInfo.toBuilder() : null;
        }

        @Override
        public final Builder developerInfo(DeveloperInfo developerInfo) {
            this.developerInfo = developerInfo;
            return this;
        }

        public final void setDeveloperInfo(DeveloperInfo.BuilderImpl developerInfo) {
            this.developerInfo = developerInfo != null ? developerInfo.build() : null;
        }

        public SkillDetails build() {
            return new SkillDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SkillDetails> {
        public Builder productDescription(String var1);

        public Builder invocationPhrase(String var1);

        public Builder releaseDate(String var1);

        public Builder endUserLicenseAgreement(String var1);

        public Builder genericKeywords(Collection<String> var1);

        public Builder genericKeywords(String ... var1);

        public Builder bulletPoints(Collection<String> var1);

        public Builder bulletPoints(String ... var1);

        public Builder newInThisVersionBulletPoints(Collection<String> var1);

        public Builder newInThisVersionBulletPoints(String ... var1);

        public Builder skillTypes(Collection<String> var1);

        public Builder skillTypes(String ... var1);

        public Builder reviews(Map<String, String> var1);

        public Builder developerInfo(DeveloperInfo var1);

        default public Builder developerInfo(Consumer<DeveloperInfo.Builder> developerInfo) {
            return this.developerInfo((DeveloperInfo)((DeveloperInfo.Builder)DeveloperInfo.builder().applyMutation(developerInfo)).build());
        }
    }
}

