/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Feature {
    BLUETOOTH("BLUETOOTH"),
    VOLUME("VOLUME"),
    NOTIFICATIONS("NOTIFICATIONS"),
    LISTS("LISTS"),
    SKILLS("SKILLS"),
    NETWORK_PROFILE("NETWORK_PROFILE"),
    SETTINGS("SETTINGS"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Feature> VALUE_MAP;
    private final String value;

    private Feature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Feature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Feature> knownValues() {
        EnumSet<Feature> knownValues = EnumSet.allOf(Feature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Feature.class, Feature::toString);
    }
}

