/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.CommsProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPDialIn
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IPDialIn> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(IPDialIn.getter(IPDialIn::endpoint)).setter(IPDialIn.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> COMMS_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommsProtocol").getter(IPDialIn.getter(IPDialIn::commsProtocolAsString)).setter(IPDialIn.setter(Builder::commsProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommsProtocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, COMMS_PROTOCOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpoint;
    private final String commsProtocol;

    private IPDialIn(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.commsProtocol = builder.commsProtocol;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final CommsProtocol commsProtocol() {
        return CommsProtocol.fromValue(this.commsProtocol);
    }

    public final String commsProtocolAsString() {
        return this.commsProtocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.commsProtocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPDialIn)) {
            return false;
        }
        IPDialIn other = (IPDialIn)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.commsProtocolAsString(), other.commsProtocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IPDialIn").add("Endpoint", (Object)this.endpoint()).add("CommsProtocol", (Object)this.commsProtocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "CommsProtocol": {
                return Optional.ofNullable(clazz.cast(this.commsProtocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPDialIn, T> g) {
        return obj -> g.apply((IPDialIn)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private String commsProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(IPDialIn model) {
            this.endpoint(model.endpoint);
            this.commsProtocol(model.commsProtocol);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getCommsProtocol() {
            return this.commsProtocol;
        }

        public final void setCommsProtocol(String commsProtocol) {
            this.commsProtocol = commsProtocol;
        }

        @Override
        public final Builder commsProtocol(String commsProtocol) {
            this.commsProtocol = commsProtocol;
            return this;
        }

        @Override
        public final Builder commsProtocol(CommsProtocol commsProtocol) {
            this.commsProtocol(commsProtocol == null ? null : commsProtocol.toString());
            return this;
        }

        public IPDialIn build() {
            return new IPDialIn(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IPDialIn> {
        public Builder endpoint(String var1);

        public Builder commsProtocol(String var1);

        public Builder commsProtocol(CommsProtocol var1);
    }
}

