/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SkillType {
    PUBLIC("PUBLIC"),
    PRIVATE("PRIVATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SkillType> VALUE_MAP;
    private final String value;

    private SkillType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SkillType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SkillType> knownValues() {
        EnumSet<SkillType> knownValues = EnumSet.allOf(SkillType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SkillType.class, SkillType::toString);
    }
}

