/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse;

public class ListSmartHomeAppliancesIterable
implements SdkIterable<ListSmartHomeAppliancesResponse> {
    private final AlexaForBusinessClient client;
    private final ListSmartHomeAppliancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSmartHomeAppliancesIterable(AlexaForBusinessClient client, ListSmartHomeAppliancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSmartHomeAppliancesResponseFetcher();
    }

    public Iterator<ListSmartHomeAppliancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSmartHomeAppliancesResponseFetcher
    implements SyncPageFetcher<ListSmartHomeAppliancesResponse> {
        private ListSmartHomeAppliancesResponseFetcher() {
        }

        public boolean hasNextPage(ListSmartHomeAppliancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSmartHomeAppliancesResponse nextPage(ListSmartHomeAppliancesResponse previousPage) {
            if (previousPage == null) {
                return ListSmartHomeAppliancesIterable.this.client.listSmartHomeAppliances(ListSmartHomeAppliancesIterable.this.firstRequest);
            }
            return ListSmartHomeAppliancesIterable.this.client.listSmartHomeAppliances((ListSmartHomeAppliancesRequest)((Object)ListSmartHomeAppliancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

