/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoomData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoomData> {
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoomArn").getter(RoomData.getter(RoomData::roomArn)).setter(RoomData.setter(Builder::roomArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()}).build();
    private static final SdkField<String> ROOM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoomName").getter(RoomData.getter(RoomData::roomName)).setter(RoomData.setter(Builder::roomName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RoomData.getter(RoomData::description)).setter(RoomData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PROVIDER_CALENDAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderCalendarId").getter(RoomData.getter(RoomData::providerCalendarId)).setter(RoomData.setter(Builder::providerCalendarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderCalendarId").build()}).build();
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileArn").getter(RoomData.getter(RoomData::profileArn)).setter(RoomData.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileName").getter(RoomData.getter(RoomData::profileName)).setter(RoomData.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ARN_FIELD, ROOM_NAME_FIELD, DESCRIPTION_FIELD, PROVIDER_CALENDAR_ID_FIELD, PROFILE_ARN_FIELD, PROFILE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roomArn;
    private final String roomName;
    private final String description;
    private final String providerCalendarId;
    private final String profileArn;
    private final String profileName;

    private RoomData(BuilderImpl builder) {
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.description = builder.description;
        this.providerCalendarId = builder.providerCalendarId;
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
    }

    public final String roomArn() {
        return this.roomArn;
    }

    public final String roomName() {
        return this.roomName;
    }

    public final String description() {
        return this.description;
    }

    public final String providerCalendarId() {
        return this.providerCalendarId;
    }

    public final String profileArn() {
        return this.profileArn;
    }

    public final String profileName() {
        return this.profileName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerCalendarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoomData)) {
            return false;
        }
        RoomData other = (RoomData)obj;
        return Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.roomName(), other.roomName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.providerCalendarId(), other.providerCalendarId()) && Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.profileName(), other.profileName());
    }

    public final String toString() {
        return ToString.builder((String)"RoomData").add("RoomArn", (Object)this.roomArn()).add("RoomName", (Object)this.roomName()).add("Description", (Object)this.description()).add("ProviderCalendarId", (Object)this.providerCalendarId()).add("ProfileArn", (Object)this.profileArn()).add("ProfileName", (Object)this.profileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
            case "RoomName": {
                return Optional.ofNullable(clazz.cast(this.roomName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ProviderCalendarId": {
                return Optional.ofNullable(clazz.cast(this.providerCalendarId()));
            }
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoomData, T> g) {
        return obj -> g.apply((RoomData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roomArn;
        private String roomName;
        private String description;
        private String providerCalendarId;
        private String profileArn;
        private String profileName;

        private BuilderImpl() {
        }

        private BuilderImpl(RoomData model) {
            this.roomArn(model.roomArn);
            this.roomName(model.roomName);
            this.description(model.description);
            this.providerCalendarId(model.providerCalendarId);
            this.profileArn(model.profileArn);
            this.profileName(model.profileName);
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final String getRoomName() {
            return this.roomName;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getProviderCalendarId() {
            return this.providerCalendarId;
        }

        public final void setProviderCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
        }

        @Override
        public final Builder providerCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
            return this;
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public RoomData build() {
            return new RoomData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoomData> {
        public Builder roomArn(String var1);

        public Builder roomName(String var1);

        public Builder description(String var1);

        public Builder providerCalendarId(String var1);

        public Builder profileArn(String var1);

        public Builder profileName(String var1);
    }
}

