/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Publication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Publication> {
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Event").getter(Publication.getter(Publication::event)).setter(Publication.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(Publication.getter(Publication::schema)).setter(Publication.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Publication.getter(Publication::description)).setter(Publication.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD, SCHEMA_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String event;
    private final String schema;
    private final String description;

    private Publication(BuilderImpl builder) {
        this.event = builder.event;
        this.schema = builder.schema;
        this.description = builder.description;
    }

    public final String event() {
        return this.event;
    }

    public final String schema() {
        return this.schema;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Publication)) {
            return false;
        }
        Publication other = (Publication)obj;
        return Objects.equals(this.event(), other.event()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"Publication").add("Event", (Object)this.event()).add("Schema", (Object)this.schema()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Event": {
                return Optional.ofNullable(clazz.cast(this.event()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Publication, T> g) {
        return obj -> g.apply((Publication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String event;
        private String schema;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(Publication model) {
            this.event(model.event);
            this.schema(model.schema);
            this.description(model.description);
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public Publication build() {
            return new Publication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Publication> {
        public Builder event(String var1);

        public Builder schema(String var1);

        public Builder description(String var1);
    }
}

