/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImagesRequest extends AppStreamRequest implements
        ToCopyableBuilder<DescribeImagesRequest.Builder, DescribeImagesRequest> {
    private static final SdkField<List<String>> NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Names")
            .getter(getter(DescribeImagesRequest::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Arns")
            .getter(getter(DescribeImagesRequest::arns))
            .setter(setter(Builder::arns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeImagesRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeImagesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeImagesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMES_FIELD, ARNS_FIELD,
            TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> names;

    private final List<String> arns;

    private final String type;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeImagesRequest(BuilderImpl builder) {
        super(builder);
        this.names = builder.names;
        this.arns = builder.arns;
        this.type = builder.type;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Names property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNames() {
        return names != null && !(names instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the public or private images to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNames} method.
     * </p>
     * 
     * @return The names of the public or private images to describe.
     */
    public final List<String> names() {
        return names;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arns property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasArns() {
        return arns != null && !(arns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the public, private, and shared images to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArns} method.
     * </p>
     * 
     * @return The ARNs of the public, private, and shared images to describe.
     */
    public final List<String> arns() {
        return arns;
    }

    /**
     * <p>
     * The type of image (public, private, or shared) to describe.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link VisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of image (public, private, or shared) to describe.
     * @see VisibilityType
     */
    public final VisibilityType type() {
        return VisibilityType.fromValue(type);
    }

    /**
     * <p>
     * The type of image (public, private, or shared) to describe.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link VisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of image (public, private, or shared) to describe.
     * @see VisibilityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum size of each page of results.
     * </p>
     * 
     * @return The maximum size of each page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNames() ? names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasArns() ? arns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesRequest)) {
            return false;
        }
        DescribeImagesRequest other = (DescribeImagesRequest) obj;
        return hasNames() == other.hasNames() && Objects.equals(names(), other.names()) && hasArns() == other.hasArns()
                && Objects.equals(arns(), other.arns()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImagesRequest").add("Names", hasNames() ? names() : null)
                .add("Arns", hasArns() ? arns() : null).add("Type", typeAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        case "Arns":
            return Optional.ofNullable(clazz.cast(arns()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesRequest, T> g) {
        return obj -> g.apply((DescribeImagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImagesRequest> {
        /**
         * <p>
         * The names of the public or private images to describe.
         * </p>
         * 
         * @param names
         *        The names of the public or private images to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * The names of the public or private images to describe.
         * </p>
         * 
         * @param names
         *        The names of the public or private images to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * The ARNs of the public, private, and shared images to describe.
         * </p>
         * 
         * @param arns
         *        The ARNs of the public, private, and shared images to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(Collection<String> arns);

        /**
         * <p>
         * The ARNs of the public, private, and shared images to describe.
         * </p>
         * 
         * @param arns
         *        The ARNs of the public, private, and shared images to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(String... arns);

        /**
         * <p>
         * The type of image (public, private, or shared) to describe.
         * </p>
         * 
         * @param type
         *        The type of image (public, private, or shared) to describe.
         * @see VisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of image (public, private, or shared) to describe.
         * </p>
         * 
         * @param type
         *        The type of image (public, private, or shared) to describe.
         * @see VisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityType
         */
        Builder type(VisibilityType type);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum size of each page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum size of each page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private List<String> names = DefaultSdkAutoConstructList.getInstance();

        private List<String> arns = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesRequest model) {
            super(model);
            names(model.names);
            arns(model.arns);
            type(model.type);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getNames() {
            if (names instanceof SdkAutoConstructList) {
                return null;
            }
            return names;
        }

        public final void setNames(Collection<String> names) {
            this.names = StringListCopier.copy(names);
        }

        @Override
        @Transient
        public final Builder names(Collection<String> names) {
            this.names = StringListCopier.copy(names);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final Collection<String> getArns() {
            if (arns instanceof SdkAutoConstructList) {
                return null;
            }
            return arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = ArnListCopier.copy(arns);
        }

        @Override
        @Transient
        public final Builder arns(Collection<String> arns) {
            this.arns = ArnListCopier.copy(arns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder arns(String... arns) {
            arns(Arrays.asList(arns));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(VisibilityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImagesRequest build() {
            return new DescribeImagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
