/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.apptest.AppTestClient;
import software.amazon.awssdk.services.apptest.AppTestServiceClientConfiguration;
import software.amazon.awssdk.services.apptest.internal.AppTestServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.apptest.model.AccessDeniedException;
import software.amazon.awssdk.services.apptest.model.AppTestException;
import software.amazon.awssdk.services.apptest.model.ConflictException;
import software.amazon.awssdk.services.apptest.model.CreateTestCaseRequest;
import software.amazon.awssdk.services.apptest.model.CreateTestCaseResponse;
import software.amazon.awssdk.services.apptest.model.CreateTestConfigurationRequest;
import software.amazon.awssdk.services.apptest.model.CreateTestConfigurationResponse;
import software.amazon.awssdk.services.apptest.model.CreateTestSuiteRequest;
import software.amazon.awssdk.services.apptest.model.CreateTestSuiteResponse;
import software.amazon.awssdk.services.apptest.model.DeleteTestCaseRequest;
import software.amazon.awssdk.services.apptest.model.DeleteTestCaseResponse;
import software.amazon.awssdk.services.apptest.model.DeleteTestConfigurationRequest;
import software.amazon.awssdk.services.apptest.model.DeleteTestConfigurationResponse;
import software.amazon.awssdk.services.apptest.model.DeleteTestRunRequest;
import software.amazon.awssdk.services.apptest.model.DeleteTestRunResponse;
import software.amazon.awssdk.services.apptest.model.DeleteTestSuiteRequest;
import software.amazon.awssdk.services.apptest.model.DeleteTestSuiteResponse;
import software.amazon.awssdk.services.apptest.model.GetTestCaseRequest;
import software.amazon.awssdk.services.apptest.model.GetTestCaseResponse;
import software.amazon.awssdk.services.apptest.model.GetTestConfigurationRequest;
import software.amazon.awssdk.services.apptest.model.GetTestConfigurationResponse;
import software.amazon.awssdk.services.apptest.model.GetTestRunStepRequest;
import software.amazon.awssdk.services.apptest.model.GetTestRunStepResponse;
import software.amazon.awssdk.services.apptest.model.GetTestSuiteRequest;
import software.amazon.awssdk.services.apptest.model.GetTestSuiteResponse;
import software.amazon.awssdk.services.apptest.model.InternalServerException;
import software.amazon.awssdk.services.apptest.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.apptest.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.apptest.model.ListTestCasesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestCasesResponse;
import software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestConfigurationsResponse;
import software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunStepsResponse;
import software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesResponse;
import software.amazon.awssdk.services.apptest.model.ListTestRunsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunsResponse;
import software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestSuitesResponse;
import software.amazon.awssdk.services.apptest.model.ResourceNotFoundException;
import software.amazon.awssdk.services.apptest.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.apptest.model.StartTestRunRequest;
import software.amazon.awssdk.services.apptest.model.StartTestRunResponse;
import software.amazon.awssdk.services.apptest.model.TagResourceRequest;
import software.amazon.awssdk.services.apptest.model.TagResourceResponse;
import software.amazon.awssdk.services.apptest.model.ThrottlingException;
import software.amazon.awssdk.services.apptest.model.UntagResourceRequest;
import software.amazon.awssdk.services.apptest.model.UntagResourceResponse;
import software.amazon.awssdk.services.apptest.model.UpdateTestCaseRequest;
import software.amazon.awssdk.services.apptest.model.UpdateTestCaseResponse;
import software.amazon.awssdk.services.apptest.model.UpdateTestConfigurationRequest;
import software.amazon.awssdk.services.apptest.model.UpdateTestConfigurationResponse;
import software.amazon.awssdk.services.apptest.model.UpdateTestSuiteRequest;
import software.amazon.awssdk.services.apptest.model.UpdateTestSuiteResponse;
import software.amazon.awssdk.services.apptest.model.ValidationException;
import software.amazon.awssdk.services.apptest.transform.CreateTestCaseRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.CreateTestConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.CreateTestSuiteRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.DeleteTestCaseRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.DeleteTestConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.DeleteTestRunRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.DeleteTestSuiteRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.GetTestCaseRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.GetTestConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.GetTestRunStepRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.GetTestSuiteRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.ListTestCasesRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.ListTestConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.ListTestRunStepsRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.ListTestRunTestCasesRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.ListTestRunsRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.ListTestSuitesRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.StartTestRunRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.UpdateTestCaseRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.UpdateTestConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apptest.transform.UpdateTestSuiteRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAppTestClient
implements AppTestClient {
    private static final Logger log = Logger.loggerFor(DefaultAppTestClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppTestClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTestCaseResponse createTestCase(CreateTestCaseRequest createTestCaseRequest) throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTestCaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTestCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, createTestCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTestCase");
            CreateTestCaseResponse createTestCaseResponse = (CreateTestCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTestCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTestCaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTestCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTestCaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$createTestCase$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTestConfigurationResponse createTestConfiguration(CreateTestConfigurationRequest createTestConfigurationRequest) throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTestConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTestConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, createTestConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTestConfiguration");
            CreateTestConfigurationResponse createTestConfigurationResponse = (CreateTestConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTestConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTestConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTestConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTestConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$createTestConfiguration$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTestSuiteResponse createTestSuite(CreateTestSuiteRequest createTestSuiteRequest) throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTestSuiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTestSuiteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, createTestSuiteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTestSuite");
            CreateTestSuiteResponse createTestSuiteResponse = (CreateTestSuiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTestSuite").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTestSuiteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTestSuiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTestSuiteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$createTestSuite$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTestCaseResponse deleteTestCase(DeleteTestCaseRequest deleteTestCaseRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTestCaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTestCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, deleteTestCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTestCase");
            DeleteTestCaseResponse deleteTestCaseResponse = (DeleteTestCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTestCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTestCaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTestCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTestCaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$deleteTestCase$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTestConfigurationResponse deleteTestConfiguration(DeleteTestConfigurationRequest deleteTestConfigurationRequest) throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTestConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTestConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, deleteTestConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTestConfiguration");
            DeleteTestConfigurationResponse deleteTestConfigurationResponse = (DeleteTestConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTestConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTestConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTestConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTestConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$deleteTestConfiguration$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTestRunResponse deleteTestRun(DeleteTestRunRequest deleteTestRunRequest) throws ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTestRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTestRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, deleteTestRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTestRun");
            DeleteTestRunResponse deleteTestRunResponse = (DeleteTestRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTestRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTestRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTestRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTestRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$deleteTestRun$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTestSuiteResponse deleteTestSuite(DeleteTestSuiteRequest deleteTestSuiteRequest) throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTestSuiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTestSuiteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, deleteTestSuiteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTestSuite");
            DeleteTestSuiteResponse deleteTestSuiteResponse = (DeleteTestSuiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTestSuite").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTestSuiteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTestSuiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTestSuiteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$deleteTestSuite$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTestCaseResponse getTestCase(GetTestCaseRequest getTestCaseRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTestCaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTestCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, getTestCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTestCase");
            GetTestCaseResponse getTestCaseResponse = (GetTestCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTestCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTestCaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTestCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTestCaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$getTestCase$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTestConfigurationResponse getTestConfiguration(GetTestConfigurationRequest getTestConfigurationRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTestConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTestConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, getTestConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTestConfiguration");
            GetTestConfigurationResponse getTestConfigurationResponse = (GetTestConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTestConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTestConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTestConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTestConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$getTestConfiguration$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTestRunStepResponse getTestRunStep(GetTestRunStepRequest getTestRunStepRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTestRunStepResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTestRunStepRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, getTestRunStepRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTestRunStep");
            GetTestRunStepResponse getTestRunStepResponse = (GetTestRunStepResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTestRunStep").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTestRunStepRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTestRunStepRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTestRunStepResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$getTestRunStep$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTestSuiteResponse getTestSuite(GetTestSuiteRequest getTestSuiteRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTestSuiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTestSuiteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, getTestSuiteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTestSuite");
            GetTestSuiteResponse getTestSuiteResponse = (GetTestSuiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTestSuite").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTestSuiteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTestSuiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTestSuiteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$getTestSuite$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$listTagsForResource$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTestCasesResponse listTestCases(ListTestCasesRequest listTestCasesRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTestCasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTestCasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, listTestCasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTestCases");
            ListTestCasesResponse listTestCasesResponse = (ListTestCasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTestCases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTestCasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTestCasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTestCasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$listTestCases$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTestConfigurationsResponse listTestConfigurations(ListTestConfigurationsRequest listTestConfigurationsRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTestConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTestConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, listTestConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTestConfigurations");
            ListTestConfigurationsResponse listTestConfigurationsResponse = (ListTestConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTestConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTestConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTestConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTestConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$listTestConfigurations$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTestRunStepsResponse listTestRunSteps(ListTestRunStepsRequest listTestRunStepsRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTestRunStepsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTestRunStepsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, listTestRunStepsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTestRunSteps");
            ListTestRunStepsResponse listTestRunStepsResponse = (ListTestRunStepsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTestRunSteps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTestRunStepsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTestRunStepsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTestRunStepsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$listTestRunSteps$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTestRunTestCasesResponse listTestRunTestCases(ListTestRunTestCasesRequest listTestRunTestCasesRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTestRunTestCasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTestRunTestCasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, listTestRunTestCasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTestRunTestCases");
            ListTestRunTestCasesResponse listTestRunTestCasesResponse = (ListTestRunTestCasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTestRunTestCases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTestRunTestCasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTestRunTestCasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTestRunTestCasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$listTestRunTestCases$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTestRunsResponse listTestRuns(ListTestRunsRequest listTestRunsRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTestRunsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTestRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, listTestRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTestRuns");
            ListTestRunsResponse listTestRunsResponse = (ListTestRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTestRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTestRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTestRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTestRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$listTestRuns$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTestSuitesResponse listTestSuites(ListTestSuitesRequest listTestSuitesRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTestSuitesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTestSuitesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, listTestSuitesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTestSuites");
            ListTestSuitesResponse listTestSuitesResponse = (ListTestSuitesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTestSuites").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTestSuitesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTestSuitesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTestSuitesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$listTestSuites$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTestRunResponse startTestRun(StartTestRunRequest startTestRunRequest) throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTestRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTestRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, startTestRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTestRun");
            StartTestRunResponse startTestRunResponse = (StartTestRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTestRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startTestRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTestRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTestRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$startTestRun$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$tagResource$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$untagResource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTestCaseResponse updateTestCase(UpdateTestCaseRequest updateTestCaseRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTestCaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTestCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, updateTestCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTestCase");
            UpdateTestCaseResponse updateTestCaseResponse = (UpdateTestCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTestCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTestCaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTestCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTestCaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$updateTestCase$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTestConfigurationResponse updateTestConfiguration(UpdateTestConfigurationRequest updateTestConfigurationRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTestConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTestConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, updateTestConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTestConfiguration");
            UpdateTestConfigurationResponse updateTestConfigurationResponse = (UpdateTestConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTestConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTestConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTestConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTestConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$updateTestConfiguration$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTestSuiteResponse updateTestSuite(UpdateTestSuiteRequest updateTestSuiteRequest) throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppTestException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTestSuiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTestSuiteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppTestClient.resolveMetricPublishers(clientConfiguration, updateTestSuiteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppTest");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTestSuite");
            UpdateTestSuiteResponse updateTestSuiteResponse = (UpdateTestSuiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTestSuite").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTestSuiteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTestSuiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTestSuiteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppTestClient.lambda$updateTestSuite$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "apptest";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        AppTestServiceClientConfigurationBuilder serviceConfigBuilder = new AppTestServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AppTestException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final AppTestServiceClientConfiguration serviceClientConfiguration() {
        return new AppTestServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTestSuite$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTestConfiguration$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTestCase$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTestRun$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTestSuites$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTestRuns$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTestRunTestCases$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTestRunSteps$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTestConfigurations$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTestCases$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTestSuite$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTestRunStep$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTestConfiguration$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTestCase$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTestSuite$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTestRun$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTestConfiguration$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTestCase$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTestSuite$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTestConfiguration$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTestCase$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

