/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecycleHookSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecycleHookSpecification> {
    private static final SdkField<String> LIFECYCLE_HOOK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHookSpecification.getter(LifecycleHookSpecification::lifecycleHookName)).setter(LifecycleHookSpecification.setter(Builder::lifecycleHookName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookName").build()}).build();
    private static final SdkField<String> LIFECYCLE_TRANSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHookSpecification.getter(LifecycleHookSpecification::lifecycleTransition)).setter(LifecycleHookSpecification.setter(Builder::lifecycleTransition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransition").build()}).build();
    private static final SdkField<String> NOTIFICATION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHookSpecification.getter(LifecycleHookSpecification::notificationMetadata)).setter(LifecycleHookSpecification.setter(Builder::notificationMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationMetadata").build()}).build();
    private static final SdkField<Integer> HEARTBEAT_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(LifecycleHookSpecification.getter(LifecycleHookSpecification::heartbeatTimeout)).setter(LifecycleHookSpecification.setter(Builder::heartbeatTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeartbeatTimeout").build()}).build();
    private static final SdkField<String> DEFAULT_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHookSpecification.getter(LifecycleHookSpecification::defaultResult)).setter(LifecycleHookSpecification.setter(Builder::defaultResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResult").build()}).build();
    private static final SdkField<String> NOTIFICATION_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHookSpecification.getter(LifecycleHookSpecification::notificationTargetARN)).setter(LifecycleHookSpecification.setter(Builder::notificationTargetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTargetARN").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHookSpecification.getter(LifecycleHookSpecification::roleARN)).setter(LifecycleHookSpecification.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOK_NAME_FIELD, LIFECYCLE_TRANSITION_FIELD, NOTIFICATION_METADATA_FIELD, HEARTBEAT_TIMEOUT_FIELD, DEFAULT_RESULT_FIELD, NOTIFICATION_TARGET_ARN_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lifecycleHookName;
    private final String lifecycleTransition;
    private final String notificationMetadata;
    private final Integer heartbeatTimeout;
    private final String defaultResult;
    private final String notificationTargetARN;
    private final String roleARN;

    private LifecycleHookSpecification(BuilderImpl builder) {
        this.lifecycleHookName = builder.lifecycleHookName;
        this.lifecycleTransition = builder.lifecycleTransition;
        this.notificationMetadata = builder.notificationMetadata;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.defaultResult = builder.defaultResult;
        this.notificationTargetARN = builder.notificationTargetARN;
        this.roleARN = builder.roleARN;
    }

    public String lifecycleHookName() {
        return this.lifecycleHookName;
    }

    public String lifecycleTransition() {
        return this.lifecycleTransition;
    }

    public String notificationMetadata() {
        return this.notificationMetadata;
    }

    public Integer heartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public String defaultResult() {
        return this.defaultResult;
    }

    public String notificationTargetARN() {
        return this.notificationTargetARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleTransition());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTargetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleHookSpecification)) {
            return false;
        }
        LifecycleHookSpecification other = (LifecycleHookSpecification)obj;
        return Objects.equals(this.lifecycleHookName(), other.lifecycleHookName()) && Objects.equals(this.lifecycleTransition(), other.lifecycleTransition()) && Objects.equals(this.notificationMetadata(), other.notificationMetadata()) && Objects.equals(this.heartbeatTimeout(), other.heartbeatTimeout()) && Objects.equals(this.defaultResult(), other.defaultResult()) && Objects.equals(this.notificationTargetARN(), other.notificationTargetARN()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public String toString() {
        return ToString.builder((String)"LifecycleHookSpecification").add("LifecycleHookName", (Object)this.lifecycleHookName()).add("LifecycleTransition", (Object)this.lifecycleTransition()).add("NotificationMetadata", (Object)this.notificationMetadata()).add("HeartbeatTimeout", (Object)this.heartbeatTimeout()).add("DefaultResult", (Object)this.defaultResult()).add("NotificationTargetARN", (Object)this.notificationTargetARN()).add("RoleARN", (Object)this.roleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHookName()));
            }
            case "LifecycleTransition": {
                return Optional.ofNullable(clazz.cast(this.lifecycleTransition()));
            }
            case "NotificationMetadata": {
                return Optional.ofNullable(clazz.cast(this.notificationMetadata()));
            }
            case "HeartbeatTimeout": {
                return Optional.ofNullable(clazz.cast(this.heartbeatTimeout()));
            }
            case "DefaultResult": {
                return Optional.ofNullable(clazz.cast(this.defaultResult()));
            }
            case "NotificationTargetARN": {
                return Optional.ofNullable(clazz.cast(this.notificationTargetARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleHookSpecification, T> g) {
        return obj -> g.apply((LifecycleHookSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleHookName;
        private String lifecycleTransition;
        private String notificationMetadata;
        private Integer heartbeatTimeout;
        private String defaultResult;
        private String notificationTargetARN;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleHookSpecification model) {
            this.lifecycleHookName(model.lifecycleHookName);
            this.lifecycleTransition(model.lifecycleTransition);
            this.notificationMetadata(model.notificationMetadata);
            this.heartbeatTimeout(model.heartbeatTimeout);
            this.defaultResult(model.defaultResult);
            this.notificationTargetARN(model.notificationTargetARN);
            this.roleARN(model.roleARN);
        }

        public final String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getLifecycleTransition() {
            return this.lifecycleTransition;
        }

        @Override
        public final Builder lifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
            return this;
        }

        public final void setLifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
        }

        public final String getNotificationMetadata() {
            return this.notificationMetadata;
        }

        @Override
        public final Builder notificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
            return this;
        }

        public final void setNotificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
        }

        public final Integer getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final void setHeartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        public final String getDefaultResult() {
            return this.defaultResult;
        }

        @Override
        public final Builder defaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public final void setDefaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
        }

        public final String getNotificationTargetARN() {
            return this.notificationTargetARN;
        }

        @Override
        public final Builder notificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
            return this;
        }

        public final void setNotificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public LifecycleHookSpecification build() {
            return new LifecycleHookSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecycleHookSpecification> {
        public Builder lifecycleHookName(String var1);

        public Builder lifecycleTransition(String var1);

        public Builder notificationMetadata(String var1);

        public Builder heartbeatTimeout(Integer var1);

        public Builder defaultResult(String var1);

        public Builder notificationTargetARN(String var1);

        public Builder roleARN(String var1);
    }
}

