/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.AutoScalingPlansResponse;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanResource;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingPlanResourcesResponse
extends AutoScalingPlansResponse
implements ToCopyableBuilder<Builder, DescribeScalingPlanResourcesResponse> {
    private static final SdkField<List<ScalingPlanResource>> SCALING_PLAN_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeScalingPlanResourcesResponse.getter(DescribeScalingPlanResourcesResponse::scalingPlanResources)).setter(DescribeScalingPlanResourcesResponse.setter(Builder::scalingPlanResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingPlanResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScalingPlanResourcesResponse.getter(DescribeScalingPlanResourcesResponse::nextToken)).setter(DescribeScalingPlanResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScalingPlanResource> scalingPlanResources;
    private final String nextToken;

    private DescribeScalingPlanResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingPlanResources = builder.scalingPlanResources;
        this.nextToken = builder.nextToken;
    }

    public boolean hasScalingPlanResources() {
        return this.scalingPlanResources != null && !(this.scalingPlanResources instanceof SdkAutoConstructList);
    }

    public List<ScalingPlanResource> scalingPlanResources() {
        return this.scalingPlanResources;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPlanResourcesResponse)) {
            return false;
        }
        DescribeScalingPlanResourcesResponse other = (DescribeScalingPlanResourcesResponse)((Object)obj);
        return Objects.equals(this.scalingPlanResources(), other.scalingPlanResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScalingPlanResourcesResponse").add("ScalingPlanResources", this.scalingPlanResources()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPlanResources": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanResources()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPlanResourcesResponse, T> g) {
        return obj -> g.apply((DescribeScalingPlanResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingPlansResponse.BuilderImpl
    implements Builder {
        private List<ScalingPlanResource> scalingPlanResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPlanResourcesResponse model) {
            super(model);
            this.scalingPlanResources(model.scalingPlanResources);
            this.nextToken(model.nextToken);
        }

        public final Collection<ScalingPlanResource.Builder> getScalingPlanResources() {
            return this.scalingPlanResources != null ? (Collection)this.scalingPlanResources.stream().map(ScalingPlanResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalingPlanResources(Collection<ScalingPlanResource> scalingPlanResources) {
            this.scalingPlanResources = ScalingPlanResourcesCopier.copy(scalingPlanResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPlanResources(ScalingPlanResource ... scalingPlanResources) {
            this.scalingPlanResources(Arrays.asList(scalingPlanResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPlanResources(Consumer<ScalingPlanResource.Builder> ... scalingPlanResources) {
            this.scalingPlanResources(Stream.of(scalingPlanResources).map(c -> (ScalingPlanResource)((ScalingPlanResource.Builder)ScalingPlanResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScalingPlanResources(Collection<ScalingPlanResource.BuilderImpl> scalingPlanResources) {
            this.scalingPlanResources = ScalingPlanResourcesCopier.copyFromBuilder(scalingPlanResources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalingPlanResourcesResponse build() {
            return new DescribeScalingPlanResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingPlansResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingPlanResourcesResponse> {
        public Builder scalingPlanResources(Collection<ScalingPlanResource> var1);

        public Builder scalingPlanResources(ScalingPlanResource ... var1);

        public Builder scalingPlanResources(Consumer<ScalingPlanResource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

