/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.CapabilityConfiguration;
import software.amazon.awssdk.services.b2bi.model.CapabilityType;
import software.amazon.awssdk.services.b2bi.model.InstructionsDocumentsCopier;
import software.amazon.awssdk.services.b2bi.model.S3Location;
import software.amazon.awssdk.services.b2bi.model.Tag;
import software.amazon.awssdk.services.b2bi.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCapabilityRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, CreateCapabilityRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::name)).setter(CreateCapabilityRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::typeAsString)).setter(CreateCapabilityRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<CapabilityConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::configuration)).setter(CreateCapabilityRequest.setter(Builder::configuration)).constructor(CapabilityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<List<S3Location>> INSTRUCTIONS_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instructionsDocuments").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::instructionsDocuments)).setter(CreateCapabilityRequest.setter(Builder::instructionsDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionsDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::clientToken)).setter(CreateCapabilityRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::tags)).setter(CreateCapabilityRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, CONFIGURATION_FIELD, INSTRUCTIONS_DOCUMENTS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("instructionsDocuments", INSTRUCTIONS_DOCUMENTS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final String type;
    private final CapabilityConfiguration configuration;
    private final List<S3Location> instructionsDocuments;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateCapabilityRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.instructionsDocuments = builder.instructionsDocuments;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final CapabilityType type() {
        return CapabilityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CapabilityConfiguration configuration() {
        return this.configuration;
    }

    public final boolean hasInstructionsDocuments() {
        return this.instructionsDocuments != null && !(this.instructionsDocuments instanceof SdkAutoConstructList);
    }

    public final List<S3Location> instructionsDocuments() {
        return this.instructionsDocuments;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstructionsDocuments() ? this.instructionsDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapabilityRequest)) {
            return false;
        }
        CreateCapabilityRequest other = (CreateCapabilityRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.configuration(), other.configuration()) && this.hasInstructionsDocuments() == other.hasInstructionsDocuments() && Objects.equals(this.instructionsDocuments(), other.instructionsDocuments()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCapabilityRequest").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Configuration", (Object)this.configuration()).add("InstructionsDocuments", this.hasInstructionsDocuments() ? this.instructionsDocuments() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "instructionsDocuments": {
                return Optional.ofNullable(clazz.cast(this.instructionsDocuments()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCapabilityRequest, T> g) {
        return obj -> g.apply((CreateCapabilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private CapabilityConfiguration configuration;
        private List<S3Location> instructionsDocuments = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapabilityRequest model) {
            super(model);
            this.name(model.name);
            this.type(model.type);
            this.configuration(model.configuration);
            this.instructionsDocuments(model.instructionsDocuments);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CapabilityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CapabilityConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CapabilityConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CapabilityConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<S3Location.Builder> getInstructionsDocuments() {
            List<S3Location.Builder> result = InstructionsDocumentsCopier.copyToBuilder(this.instructionsDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstructionsDocuments(Collection<S3Location.BuilderImpl> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copyFromBuilder(instructionsDocuments);
        }

        @Override
        public final Builder instructionsDocuments(Collection<S3Location> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copy(instructionsDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(S3Location ... instructionsDocuments) {
            this.instructionsDocuments(Arrays.asList(instructionsDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(Consumer<S3Location.Builder> ... instructionsDocuments) {
            this.instructionsDocuments(Stream.of(instructionsDocuments).map(c -> (S3Location)((S3Location.Builder)S3Location.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapabilityRequest build() {
            return new CreateCapabilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCapabilityRequest> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(CapabilityType var1);

        public Builder configuration(CapabilityConfiguration var1);

        default public Builder configuration(Consumer<CapabilityConfiguration.Builder> configuration) {
            return this.configuration((CapabilityConfiguration)((CapabilityConfiguration.Builder)CapabilityConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder instructionsDocuments(Collection<S3Location> var1);

        public Builder instructionsDocuments(S3Location ... var1);

        public Builder instructionsDocuments(Consumer<S3Location.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

