/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CloudWatch logging configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchConfig.Builder, CloudWatchConfig> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(CloudWatchConfig::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CloudWatchConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<S3Config> LARGE_DATA_DELIVERY_S3_CONFIG_FIELD = SdkField
            .<S3Config> builder(MarshallingType.SDK_POJO).memberName("largeDataDeliveryS3Config")
            .getter(getter(CloudWatchConfig::largeDataDeliveryS3Config)).setter(setter(Builder::largeDataDeliveryS3Config))
            .constructor(S3Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("largeDataDeliveryS3Config").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            ROLE_ARN_FIELD, LARGE_DATA_DELIVERY_S3_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logGroupName;

    private final String roleArn;

    private final S3Config largeDataDeliveryS3Config;

    private CloudWatchConfig(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.roleArn = builder.roleArn;
        this.largeDataDeliveryS3Config = builder.largeDataDeliveryS3Config;
    }

    /**
     * <p>
     * The log group name.
     * </p>
     * 
     * @return The log group name.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The role ARN.
     * </p>
     * 
     * @return The role ARN.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * S3 configuration for delivering a large amount of data.
     * </p>
     * 
     * @return S3 configuration for delivering a large amount of data.
     */
    public final S3Config largeDataDeliveryS3Config() {
        return largeDataDeliveryS3Config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(largeDataDeliveryS3Config());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchConfig)) {
            return false;
        }
        CloudWatchConfig other = (CloudWatchConfig) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(largeDataDeliveryS3Config(), other.largeDataDeliveryS3Config());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchConfig").add("LogGroupName", logGroupName()).add("RoleArn", roleArn())
                .add("LargeDataDeliveryS3Config", largeDataDeliveryS3Config()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "largeDataDeliveryS3Config":
            return Optional.ofNullable(clazz.cast(largeDataDeliveryS3Config()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchConfig, T> g) {
        return obj -> g.apply((CloudWatchConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchConfig> {
        /**
         * <p>
         * The log group name.
         * </p>
         * 
         * @param logGroupName
         *        The log group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The role ARN.
         * </p>
         * 
         * @param roleArn
         *        The role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * S3 configuration for delivering a large amount of data.
         * </p>
         * 
         * @param largeDataDeliveryS3Config
         *        S3 configuration for delivering a large amount of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder largeDataDeliveryS3Config(S3Config largeDataDeliveryS3Config);

        /**
         * <p>
         * S3 configuration for delivering a large amount of data.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Config.Builder} avoiding the need to
         * create one manually via {@link S3Config#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Config.Builder#build()} is called immediately and its result is
         * passed to {@link #largeDataDeliveryS3Config(S3Config)}.
         * 
         * @param largeDataDeliveryS3Config
         *        a consumer that will call methods on {@link S3Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #largeDataDeliveryS3Config(S3Config)
         */
        default Builder largeDataDeliveryS3Config(Consumer<S3Config.Builder> largeDataDeliveryS3Config) {
            return largeDataDeliveryS3Config(S3Config.builder().applyMutation(largeDataDeliveryS3Config).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String logGroupName;

        private String roleArn;

        private S3Config largeDataDeliveryS3Config;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchConfig model) {
            logGroupName(model.logGroupName);
            roleArn(model.roleArn);
            largeDataDeliveryS3Config(model.largeDataDeliveryS3Config);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final S3Config.Builder getLargeDataDeliveryS3Config() {
            return largeDataDeliveryS3Config != null ? largeDataDeliveryS3Config.toBuilder() : null;
        }

        public final void setLargeDataDeliveryS3Config(S3Config.BuilderImpl largeDataDeliveryS3Config) {
            this.largeDataDeliveryS3Config = largeDataDeliveryS3Config != null ? largeDataDeliveryS3Config.build() : null;
        }

        @Override
        public final Builder largeDataDeliveryS3Config(S3Config largeDataDeliveryS3Config) {
            this.largeDataDeliveryS3Config = largeDataDeliveryS3Config;
            return this;
        }

        @Override
        public CloudWatchConfig build() {
            return new CloudWatchConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
