/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.ConfluenceDataSourceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.DataSourceType;
import software.amazon.awssdk.services.bedrockagent.model.S3DataSourceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.SalesforceDataSourceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.SharePointDataSourceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.WebDataSourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfiguration> {
    private static final SdkField<ConfluenceDataSourceConfiguration> CONFLUENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("confluenceConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::confluenceConfiguration)).setter(DataSourceConfiguration.setter(Builder::confluenceConfiguration)).constructor(ConfluenceDataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confluenceConfiguration").build()}).build();
    private static final SdkField<S3DataSourceConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Configuration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::s3Configuration)).setter(DataSourceConfiguration.setter(Builder::s3Configuration)).constructor(S3DataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()}).build();
    private static final SdkField<SalesforceDataSourceConfiguration> SALESFORCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("salesforceConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::salesforceConfiguration)).setter(DataSourceConfiguration.setter(Builder::salesforceConfiguration)).constructor(SalesforceDataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("salesforceConfiguration").build()}).build();
    private static final SdkField<SharePointDataSourceConfiguration> SHARE_POINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sharePointConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::sharePointConfiguration)).setter(DataSourceConfiguration.setter(Builder::sharePointConfiguration)).constructor(SharePointDataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharePointConfiguration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DataSourceConfiguration.getter(DataSourceConfiguration::typeAsString)).setter(DataSourceConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<WebDataSourceConfiguration> WEB_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("webConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::webConfiguration)).setter(DataSourceConfiguration.setter(Builder::webConfiguration)).constructor(WebDataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLUENCE_CONFIGURATION_FIELD, S3_CONFIGURATION_FIELD, SALESFORCE_CONFIGURATION_FIELD, SHARE_POINT_CONFIGURATION_FIELD, TYPE_FIELD, WEB_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ConfluenceDataSourceConfiguration confluenceConfiguration;
    private final S3DataSourceConfiguration s3Configuration;
    private final SalesforceDataSourceConfiguration salesforceConfiguration;
    private final SharePointDataSourceConfiguration sharePointConfiguration;
    private final String type;
    private final WebDataSourceConfiguration webConfiguration;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.confluenceConfiguration = builder.confluenceConfiguration;
        this.s3Configuration = builder.s3Configuration;
        this.salesforceConfiguration = builder.salesforceConfiguration;
        this.sharePointConfiguration = builder.sharePointConfiguration;
        this.type = builder.type;
        this.webConfiguration = builder.webConfiguration;
    }

    public final ConfluenceDataSourceConfiguration confluenceConfiguration() {
        return this.confluenceConfiguration;
    }

    public final S3DataSourceConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public final SalesforceDataSourceConfiguration salesforceConfiguration() {
        return this.salesforceConfiguration;
    }

    public final SharePointDataSourceConfiguration sharePointConfiguration() {
        return this.sharePointConfiguration;
    }

    public final DataSourceType type() {
        return DataSourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final WebDataSourceConfiguration webConfiguration() {
        return this.webConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.confluenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharePointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration)obj;
        return Objects.equals(this.confluenceConfiguration(), other.confluenceConfiguration()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.salesforceConfiguration(), other.salesforceConfiguration()) && Objects.equals(this.sharePointConfiguration(), other.sharePointConfiguration()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.webConfiguration(), other.webConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceConfiguration").add("ConfluenceConfiguration", (Object)this.confluenceConfiguration()).add("S3Configuration", (Object)this.s3Configuration()).add("SalesforceConfiguration", (Object)this.salesforceConfiguration()).add("SharePointConfiguration", (Object)this.sharePointConfiguration()).add("Type", (Object)this.typeAsString()).add("WebConfiguration", (Object)this.webConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "confluenceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.confluenceConfiguration()));
            }
            case "s3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "salesforceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.salesforceConfiguration()));
            }
            case "sharePointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sharePointConfiguration()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "webConfiguration": {
                return Optional.ofNullable(clazz.cast(this.webConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConfluenceDataSourceConfiguration confluenceConfiguration;
        private S3DataSourceConfiguration s3Configuration;
        private SalesforceDataSourceConfiguration salesforceConfiguration;
        private SharePointDataSourceConfiguration sharePointConfiguration;
        private String type;
        private WebDataSourceConfiguration webConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            this.confluenceConfiguration(model.confluenceConfiguration);
            this.s3Configuration(model.s3Configuration);
            this.salesforceConfiguration(model.salesforceConfiguration);
            this.sharePointConfiguration(model.sharePointConfiguration);
            this.type(model.type);
            this.webConfiguration(model.webConfiguration);
        }

        public final ConfluenceDataSourceConfiguration.Builder getConfluenceConfiguration() {
            return this.confluenceConfiguration != null ? this.confluenceConfiguration.toBuilder() : null;
        }

        public final void setConfluenceConfiguration(ConfluenceDataSourceConfiguration.BuilderImpl confluenceConfiguration) {
            this.confluenceConfiguration = confluenceConfiguration != null ? confluenceConfiguration.build() : null;
        }

        @Override
        public final Builder confluenceConfiguration(ConfluenceDataSourceConfiguration confluenceConfiguration) {
            this.confluenceConfiguration = confluenceConfiguration;
            return this;
        }

        public final S3DataSourceConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DataSourceConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DataSourceConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final SalesforceDataSourceConfiguration.Builder getSalesforceConfiguration() {
            return this.salesforceConfiguration != null ? this.salesforceConfiguration.toBuilder() : null;
        }

        public final void setSalesforceConfiguration(SalesforceDataSourceConfiguration.BuilderImpl salesforceConfiguration) {
            this.salesforceConfiguration = salesforceConfiguration != null ? salesforceConfiguration.build() : null;
        }

        @Override
        public final Builder salesforceConfiguration(SalesforceDataSourceConfiguration salesforceConfiguration) {
            this.salesforceConfiguration = salesforceConfiguration;
            return this;
        }

        public final SharePointDataSourceConfiguration.Builder getSharePointConfiguration() {
            return this.sharePointConfiguration != null ? this.sharePointConfiguration.toBuilder() : null;
        }

        public final void setSharePointConfiguration(SharePointDataSourceConfiguration.BuilderImpl sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration != null ? sharePointConfiguration.build() : null;
        }

        @Override
        public final Builder sharePointConfiguration(SharePointDataSourceConfiguration sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final WebDataSourceConfiguration.Builder getWebConfiguration() {
            return this.webConfiguration != null ? this.webConfiguration.toBuilder() : null;
        }

        public final void setWebConfiguration(WebDataSourceConfiguration.BuilderImpl webConfiguration) {
            this.webConfiguration = webConfiguration != null ? webConfiguration.build() : null;
        }

        @Override
        public final Builder webConfiguration(WebDataSourceConfiguration webConfiguration) {
            this.webConfiguration = webConfiguration;
            return this;
        }

        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfiguration> {
        public Builder confluenceConfiguration(ConfluenceDataSourceConfiguration var1);

        default public Builder confluenceConfiguration(Consumer<ConfluenceDataSourceConfiguration.Builder> confluenceConfiguration) {
            return this.confluenceConfiguration((ConfluenceDataSourceConfiguration)((ConfluenceDataSourceConfiguration.Builder)ConfluenceDataSourceConfiguration.builder().applyMutation(confluenceConfiguration)).build());
        }

        public Builder s3Configuration(S3DataSourceConfiguration var1);

        default public Builder s3Configuration(Consumer<S3DataSourceConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3DataSourceConfiguration)((S3DataSourceConfiguration.Builder)S3DataSourceConfiguration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder salesforceConfiguration(SalesforceDataSourceConfiguration var1);

        default public Builder salesforceConfiguration(Consumer<SalesforceDataSourceConfiguration.Builder> salesforceConfiguration) {
            return this.salesforceConfiguration((SalesforceDataSourceConfiguration)((SalesforceDataSourceConfiguration.Builder)SalesforceDataSourceConfiguration.builder().applyMutation(salesforceConfiguration)).build());
        }

        public Builder sharePointConfiguration(SharePointDataSourceConfiguration var1);

        default public Builder sharePointConfiguration(Consumer<SharePointDataSourceConfiguration.Builder> sharePointConfiguration) {
            return this.sharePointConfiguration((SharePointDataSourceConfiguration)((SharePointDataSourceConfiguration.Builder)SharePointDataSourceConfiguration.builder().applyMutation(sharePointConfiguration)).build());
        }

        public Builder type(String var1);

        public Builder type(DataSourceType var1);

        public Builder webConfiguration(WebDataSourceConfiguration var1);

        default public Builder webConfiguration(Consumer<WebDataSourceConfiguration.Builder> webConfiguration) {
            return this.webConfiguration((WebDataSourceConfiguration)((WebDataSourceConfiguration.Builder)WebDataSourceConfiguration.builder().applyMutation(webConfiguration)).build());
        }
    }
}

