/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.CreationMode;
import software.amazon.awssdk.services.bedrockagent.model.InferenceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptState;
import software.amazon.awssdk.services.bedrockagent.model.PromptType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PromptConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PromptConfiguration> {
    private static final SdkField<String> BASE_PROMPT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("basePromptTemplate").getter(PromptConfiguration.getter(PromptConfiguration::basePromptTemplate)).setter(PromptConfiguration.setter(Builder::basePromptTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basePromptTemplate").build()}).build();
    private static final SdkField<InferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfiguration").getter(PromptConfiguration.getter(PromptConfiguration::inferenceConfiguration)).setter(PromptConfiguration.setter(Builder::inferenceConfiguration)).constructor(InferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build()}).build();
    private static final SdkField<String> PARSER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parserMode").getter(PromptConfiguration.getter(PromptConfiguration::parserModeAsString)).setter(PromptConfiguration.setter(Builder::parserMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parserMode").build()}).build();
    private static final SdkField<String> PROMPT_CREATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptCreationMode").getter(PromptConfiguration.getter(PromptConfiguration::promptCreationModeAsString)).setter(PromptConfiguration.setter(Builder::promptCreationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptCreationMode").build()}).build();
    private static final SdkField<String> PROMPT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptState").getter(PromptConfiguration.getter(PromptConfiguration::promptStateAsString)).setter(PromptConfiguration.setter(Builder::promptState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptState").build()}).build();
    private static final SdkField<String> PROMPT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptType").getter(PromptConfiguration.getter(PromptConfiguration::promptTypeAsString)).setter(PromptConfiguration.setter(Builder::promptType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_PROMPT_TEMPLATE_FIELD, INFERENCE_CONFIGURATION_FIELD, PARSER_MODE_FIELD, PROMPT_CREATION_MODE_FIELD, PROMPT_STATE_FIELD, PROMPT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String basePromptTemplate;
    private final InferenceConfiguration inferenceConfiguration;
    private final String parserMode;
    private final String promptCreationMode;
    private final String promptState;
    private final String promptType;

    private PromptConfiguration(BuilderImpl builder) {
        this.basePromptTemplate = builder.basePromptTemplate;
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.parserMode = builder.parserMode;
        this.promptCreationMode = builder.promptCreationMode;
        this.promptState = builder.promptState;
        this.promptType = builder.promptType;
    }

    public final String basePromptTemplate() {
        return this.basePromptTemplate;
    }

    public final InferenceConfiguration inferenceConfiguration() {
        return this.inferenceConfiguration;
    }

    public final CreationMode parserMode() {
        return CreationMode.fromValue(this.parserMode);
    }

    public final String parserModeAsString() {
        return this.parserMode;
    }

    public final CreationMode promptCreationMode() {
        return CreationMode.fromValue(this.promptCreationMode);
    }

    public final String promptCreationModeAsString() {
        return this.promptCreationMode;
    }

    public final PromptState promptState() {
        return PromptState.fromValue(this.promptState);
    }

    public final String promptStateAsString() {
        return this.promptState;
    }

    public final PromptType promptType() {
        return PromptType.fromValue(this.promptType);
    }

    public final String promptTypeAsString() {
        return this.promptType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.basePromptTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.parserModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptCreationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptConfiguration)) {
            return false;
        }
        PromptConfiguration other = (PromptConfiguration)obj;
        return Objects.equals(this.basePromptTemplate(), other.basePromptTemplate()) && Objects.equals(this.inferenceConfiguration(), other.inferenceConfiguration()) && Objects.equals(this.parserModeAsString(), other.parserModeAsString()) && Objects.equals(this.promptCreationModeAsString(), other.promptCreationModeAsString()) && Objects.equals(this.promptStateAsString(), other.promptStateAsString()) && Objects.equals(this.promptTypeAsString(), other.promptTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PromptConfiguration").add("BasePromptTemplate", (Object)(this.basePromptTemplate() == null ? null : "*** Sensitive Data Redacted ***")).add("InferenceConfiguration", (Object)this.inferenceConfiguration()).add("ParserMode", (Object)this.parserModeAsString()).add("PromptCreationMode", (Object)this.promptCreationModeAsString()).add("PromptState", (Object)this.promptStateAsString()).add("PromptType", (Object)this.promptTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "basePromptTemplate": {
                return Optional.ofNullable(clazz.cast(this.basePromptTemplate()));
            }
            case "inferenceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfiguration()));
            }
            case "parserMode": {
                return Optional.ofNullable(clazz.cast(this.parserModeAsString()));
            }
            case "promptCreationMode": {
                return Optional.ofNullable(clazz.cast(this.promptCreationModeAsString()));
            }
            case "promptState": {
                return Optional.ofNullable(clazz.cast(this.promptStateAsString()));
            }
            case "promptType": {
                return Optional.ofNullable(clazz.cast(this.promptTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptConfiguration, T> g) {
        return obj -> g.apply((PromptConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String basePromptTemplate;
        private InferenceConfiguration inferenceConfiguration;
        private String parserMode;
        private String promptCreationMode;
        private String promptState;
        private String promptType;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptConfiguration model) {
            this.basePromptTemplate(model.basePromptTemplate);
            this.inferenceConfiguration(model.inferenceConfiguration);
            this.parserMode(model.parserMode);
            this.promptCreationMode(model.promptCreationMode);
            this.promptState(model.promptState);
            this.promptType(model.promptType);
        }

        public final String getBasePromptTemplate() {
            return this.basePromptTemplate;
        }

        public final void setBasePromptTemplate(String basePromptTemplate) {
            this.basePromptTemplate = basePromptTemplate;
        }

        @Override
        public final Builder basePromptTemplate(String basePromptTemplate) {
            this.basePromptTemplate = basePromptTemplate;
            return this;
        }

        public final InferenceConfiguration.Builder getInferenceConfiguration() {
            return this.inferenceConfiguration != null ? this.inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(InferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(InferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final String getParserMode() {
            return this.parserMode;
        }

        public final void setParserMode(String parserMode) {
            this.parserMode = parserMode;
        }

        @Override
        public final Builder parserMode(String parserMode) {
            this.parserMode = parserMode;
            return this;
        }

        @Override
        public final Builder parserMode(CreationMode parserMode) {
            this.parserMode(parserMode == null ? null : parserMode.toString());
            return this;
        }

        public final String getPromptCreationMode() {
            return this.promptCreationMode;
        }

        public final void setPromptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
        }

        @Override
        public final Builder promptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
            return this;
        }

        @Override
        public final Builder promptCreationMode(CreationMode promptCreationMode) {
            this.promptCreationMode(promptCreationMode == null ? null : promptCreationMode.toString());
            return this;
        }

        public final String getPromptState() {
            return this.promptState;
        }

        public final void setPromptState(String promptState) {
            this.promptState = promptState;
        }

        @Override
        public final Builder promptState(String promptState) {
            this.promptState = promptState;
            return this;
        }

        @Override
        public final Builder promptState(PromptState promptState) {
            this.promptState(promptState == null ? null : promptState.toString());
            return this;
        }

        public final String getPromptType() {
            return this.promptType;
        }

        public final void setPromptType(String promptType) {
            this.promptType = promptType;
        }

        @Override
        public final Builder promptType(String promptType) {
            this.promptType = promptType;
            return this;
        }

        @Override
        public final Builder promptType(PromptType promptType) {
            this.promptType(promptType == null ? null : promptType.toString());
            return this;
        }

        public PromptConfiguration build() {
            return new PromptConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PromptConfiguration> {
        public Builder basePromptTemplate(String var1);

        public Builder inferenceConfiguration(InferenceConfiguration var1);

        default public Builder inferenceConfiguration(Consumer<InferenceConfiguration.Builder> inferenceConfiguration) {
            return this.inferenceConfiguration((InferenceConfiguration)((InferenceConfiguration.Builder)InferenceConfiguration.builder().applyMutation(inferenceConfiguration)).build());
        }

        public Builder parserMode(String var1);

        public Builder parserMode(CreationMode var1);

        public Builder promptCreationMode(String var1);

        public Builder promptCreationMode(CreationMode var1);

        public Builder promptState(String var1);

        public Builder promptState(PromptState var1);

        public Builder promptType(String var1);

        public Builder promptType(PromptType var1);
    }
}

