/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemFlatChargeDetails;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemPercentageChargeDetails;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomLineItemChargeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomLineItemChargeDetails> {
    private static final SdkField<CustomLineItemFlatChargeDetails> FLAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Flat").getter(CustomLineItemChargeDetails.getter(CustomLineItemChargeDetails::flat)).setter(CustomLineItemChargeDetails.setter(Builder::flat)).constructor(CustomLineItemFlatChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flat").build()}).build();
    private static final SdkField<CustomLineItemPercentageChargeDetails> PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Percentage").getter(CustomLineItemChargeDetails.getter(CustomLineItemChargeDetails::percentage)).setter(CustomLineItemChargeDetails.setter(Builder::percentage)).constructor(CustomLineItemPercentageChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CustomLineItemChargeDetails.getter(CustomLineItemChargeDetails::typeAsString)).setter(CustomLineItemChargeDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLAT_FIELD, PERCENTAGE_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final CustomLineItemFlatChargeDetails flat;
    private final CustomLineItemPercentageChargeDetails percentage;
    private final String type;

    private CustomLineItemChargeDetails(BuilderImpl builder) {
        this.flat = builder.flat;
        this.percentage = builder.percentage;
        this.type = builder.type;
    }

    public final CustomLineItemFlatChargeDetails flat() {
        return this.flat;
    }

    public final CustomLineItemPercentageChargeDetails percentage() {
        return this.percentage;
    }

    public final CustomLineItemType type() {
        return CustomLineItemType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flat());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemChargeDetails)) {
            return false;
        }
        CustomLineItemChargeDetails other = (CustomLineItemChargeDetails)obj;
        return Objects.equals(this.flat(), other.flat()) && Objects.equals(this.percentage(), other.percentage()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomLineItemChargeDetails").add("Flat", (Object)this.flat()).add("Percentage", (Object)this.percentage()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Flat": {
                return Optional.ofNullable(clazz.cast(this.flat()));
            }
            case "Percentage": {
                return Optional.ofNullable(clazz.cast(this.percentage()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemChargeDetails, T> g) {
        return obj -> g.apply((CustomLineItemChargeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CustomLineItemFlatChargeDetails flat;
        private CustomLineItemPercentageChargeDetails percentage;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemChargeDetails model) {
            this.flat(model.flat);
            this.percentage(model.percentage);
            this.type(model.type);
        }

        public final CustomLineItemFlatChargeDetails.Builder getFlat() {
            return this.flat != null ? this.flat.toBuilder() : null;
        }

        public final void setFlat(CustomLineItemFlatChargeDetails.BuilderImpl flat) {
            this.flat = flat != null ? flat.build() : null;
        }

        @Override
        public final Builder flat(CustomLineItemFlatChargeDetails flat) {
            this.flat = flat;
            return this;
        }

        public final CustomLineItemPercentageChargeDetails.Builder getPercentage() {
            return this.percentage != null ? this.percentage.toBuilder() : null;
        }

        public final void setPercentage(CustomLineItemPercentageChargeDetails.BuilderImpl percentage) {
            this.percentage = percentage != null ? percentage.build() : null;
        }

        @Override
        public final Builder percentage(CustomLineItemPercentageChargeDetails percentage) {
            this.percentage = percentage;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CustomLineItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public CustomLineItemChargeDetails build() {
            return new CustomLineItemChargeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomLineItemChargeDetails> {
        public Builder flat(CustomLineItemFlatChargeDetails var1);

        default public Builder flat(Consumer<CustomLineItemFlatChargeDetails.Builder> flat) {
            return this.flat((CustomLineItemFlatChargeDetails)((CustomLineItemFlatChargeDetails.Builder)CustomLineItemFlatChargeDetails.builder().applyMutation(flat)).build());
        }

        public Builder percentage(CustomLineItemPercentageChargeDetails var1);

        default public Builder percentage(Consumer<CustomLineItemPercentageChargeDetails.Builder> percentage) {
            return this.percentage((CustomLineItemPercentageChargeDetails)((CustomLineItemPercentageChargeDetails.Builder)CustomLineItemPercentageChargeDetails.builder().applyMutation(percentage)).build());
        }

        public Builder type(String var1);

        public Builder type(CustomLineItemType var1);
    }
}

