/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemVersionListElement;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse;

public class ListCustomLineItemVersionsPublisher
implements SdkPublisher<ListCustomLineItemVersionsResponse> {
    private final BillingconductorAsyncClient client;
    private final ListCustomLineItemVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomLineItemVersionsPublisher(BillingconductorAsyncClient client, ListCustomLineItemVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomLineItemVersionsPublisher(BillingconductorAsyncClient client, ListCustomLineItemVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomLineItemVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomLineItemVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomLineItemVersionListElement> customLineItemVersions() {
        Function<ListCustomLineItemVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customLineItemVersions() != null) {
                return response.customLineItemVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomLineItemVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomLineItemVersionsResponseFetcher
    implements AsyncPageFetcher<ListCustomLineItemVersionsResponse> {
        private ListCustomLineItemVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomLineItemVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomLineItemVersionsResponse> nextPage(ListCustomLineItemVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomLineItemVersionsPublisher.this.client.listCustomLineItemVersions(ListCustomLineItemVersionsPublisher.this.firstRequest);
            }
            return ListCustomLineItemVersionsPublisher.this.client.listCustomLineItemVersions((ListCustomLineItemVersionsRequest)((Object)ListCustomLineItemVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

