/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LineItemFilterValue {
    SAVINGS_PLAN_NEGATION("SAVINGS_PLAN_NEGATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LineItemFilterValue> VALUE_MAP;
    private final String value;

    private LineItemFilterValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LineItemFilterValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LineItemFilterValue> knownValues() {
        EnumSet<LineItemFilterValue> knownValues = EnumSet.allOf(LineItemFilterValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LineItemFilterValue.class, LineItemFilterValue::toString);
    }
}

