/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request of UpdateNotification
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNotificationRequest extends BudgetsRequest implements
        ToCopyableBuilder<UpdateNotificationRequest.Builder, UpdateNotificationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(UpdateNotificationRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BudgetName").getter(getter(UpdateNotificationRequest::budgetName)).setter(setter(Builder::budgetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()).build();

    private static final SdkField<Notification> OLD_NOTIFICATION_FIELD = SdkField
            .<Notification> builder(MarshallingType.SDK_POJO).memberName("OldNotification")
            .getter(getter(UpdateNotificationRequest::oldNotification)).setter(setter(Builder::oldNotification))
            .constructor(Notification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldNotification").build()).build();

    private static final SdkField<Notification> NEW_NOTIFICATION_FIELD = SdkField
            .<Notification> builder(MarshallingType.SDK_POJO).memberName("NewNotification")
            .getter(getter(UpdateNotificationRequest::newNotification)).setter(setter(Builder::newNotification))
            .constructor(Notification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewNotification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUDGET_NAME_FIELD, OLD_NOTIFICATION_FIELD, NEW_NOTIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String budgetName;

    private final Notification oldNotification;

    private final Notification newNotification;

    private UpdateNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.oldNotification = builder.oldNotification;
        this.newNotification = builder.newNotification;
    }

    /**
     * <p>
     * The <code>accountId</code> that is associated with the budget whose notification you want to update.
     * </p>
     * 
     * @return The <code>accountId</code> that is associated with the budget whose notification you want to update.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the budget whose notification you want to update.
     * </p>
     * 
     * @return The name of the budget whose notification you want to update.
     */
    public final String budgetName() {
        return budgetName;
    }

    /**
     * <p>
     * The previous notification that is associated with a budget.
     * </p>
     * 
     * @return The previous notification that is associated with a budget.
     */
    public final Notification oldNotification() {
        return oldNotification;
    }

    /**
     * <p>
     * The updated notification to be associated with a budget.
     * </p>
     * 
     * @return The updated notification to be associated with a budget.
     */
    public final Notification newNotification() {
        return newNotification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(oldNotification());
        hashCode = 31 * hashCode + Objects.hashCode(newNotification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationRequest)) {
            return false;
        }
        UpdateNotificationRequest other = (UpdateNotificationRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(budgetName(), other.budgetName())
                && Objects.equals(oldNotification(), other.oldNotification())
                && Objects.equals(newNotification(), other.newNotification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNotificationRequest").add("AccountId", accountId()).add("BudgetName", budgetName())
                .add("OldNotification", oldNotification()).add("NewNotification", newNotification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "BudgetName":
            return Optional.ofNullable(clazz.cast(budgetName()));
        case "OldNotification":
            return Optional.ofNullable(clazz.cast(oldNotification()));
        case "NewNotification":
            return Optional.ofNullable(clazz.cast(newNotification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("BudgetName", BUDGET_NAME_FIELD);
        map.put("OldNotification", OLD_NOTIFICATION_FIELD);
        map.put("NewNotification", NEW_NOTIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotificationRequest, T> g) {
        return obj -> g.apply((UpdateNotificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNotificationRequest> {
        /**
         * <p>
         * The <code>accountId</code> that is associated with the budget whose notification you want to update.
         * </p>
         * 
         * @param accountId
         *        The <code>accountId</code> that is associated with the budget whose notification you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the budget whose notification you want to update.
         * </p>
         * 
         * @param budgetName
         *        The name of the budget whose notification you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * <p>
         * The previous notification that is associated with a budget.
         * </p>
         * 
         * @param oldNotification
         *        The previous notification that is associated with a budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldNotification(Notification oldNotification);

        /**
         * <p>
         * The previous notification that is associated with a budget.
         * </p>
         * This is a convenience method that creates an instance of the {@link Notification.Builder} avoiding the need
         * to create one manually via {@link Notification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #oldNotification(Notification)}.
         * 
         * @param oldNotification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oldNotification(Notification)
         */
        default Builder oldNotification(Consumer<Notification.Builder> oldNotification) {
            return oldNotification(Notification.builder().applyMutation(oldNotification).build());
        }

        /**
         * <p>
         * The updated notification to be associated with a budget.
         * </p>
         * 
         * @param newNotification
         *        The updated notification to be associated with a budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newNotification(Notification newNotification);

        /**
         * <p>
         * The updated notification to be associated with a budget.
         * </p>
         * This is a convenience method that creates an instance of the {@link Notification.Builder} avoiding the need
         * to create one manually via {@link Notification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #newNotification(Notification)}.
         * 
         * @param newNotification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newNotification(Notification)
         */
        default Builder newNotification(Consumer<Notification.Builder> newNotification) {
            return newNotification(Notification.builder().applyMutation(newNotification).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BudgetsRequest.BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Notification oldNotification;

        private Notification newNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationRequest model) {
            super(model);
            accountId(model.accountId);
            budgetName(model.budgetName);
            oldNotification(model.oldNotification);
            newNotification(model.newNotification);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final Notification.Builder getOldNotification() {
            return oldNotification != null ? oldNotification.toBuilder() : null;
        }

        public final void setOldNotification(Notification.BuilderImpl oldNotification) {
            this.oldNotification = oldNotification != null ? oldNotification.build() : null;
        }

        @Override
        public final Builder oldNotification(Notification oldNotification) {
            this.oldNotification = oldNotification;
            return this;
        }

        public final Notification.Builder getNewNotification() {
            return newNotification != null ? newNotification.toBuilder() : null;
        }

        public final void setNewNotification(Notification.BuilderImpl newNotification) {
            this.newNotification = newNotification != null ? newNotification.build() : null;
        }

        @Override
        public final Builder newNotification(Notification newNotification) {
            this.newNotification = newNotification;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationRequest build() {
            return new UpdateNotificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
