/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAttendeeRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, CreateAttendeeRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAttendeeRequest.getter(CreateAttendeeRequest::meetingId)).setter(CreateAttendeeRequest.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meetingId").build()}).build();
    private static final SdkField<String> EXTERNAL_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAttendeeRequest.getter(CreateAttendeeRequest::externalUserId)).setter(CreateAttendeeRequest.setter(Builder::externalUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalUserId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD, EXTERNAL_USER_ID_FIELD));
    private final String meetingId;
    private final String externalUserId;

    private CreateAttendeeRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.externalUserId = builder.externalUserId;
    }

    public String meetingId() {
        return this.meetingId;
    }

    public String externalUserId() {
        return this.externalUserId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalUserId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAttendeeRequest)) {
            return false;
        }
        CreateAttendeeRequest other = (CreateAttendeeRequest)((Object)obj);
        return Objects.equals(this.meetingId(), other.meetingId()) && Objects.equals(this.externalUserId(), other.externalUserId());
    }

    public String toString() {
        return ToString.builder((String)"CreateAttendeeRequest").add("MeetingId", (Object)this.meetingId()).add("ExternalUserId", (Object)(this.externalUserId() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
            case "ExternalUserId": {
                return Optional.ofNullable(clazz.cast(this.externalUserId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAttendeeRequest, T> g) {
        return obj -> g.apply((CreateAttendeeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String meetingId;
        private String externalUserId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAttendeeRequest model) {
            super(model);
            this.meetingId(model.meetingId);
            this.externalUserId(model.externalUserId);
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        public final String getExternalUserId() {
            return this.externalUserId;
        }

        @Override
        public final Builder externalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
            return this;
        }

        public final void setExternalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAttendeeRequest build() {
            return new CreateAttendeeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAttendeeRequest> {
        public Builder meetingId(String var1);

        public Builder externalUserId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

