/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationConfiguredAudienceModelAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationConfiguredAudienceModelAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationConfiguredAudienceModelAssociationsResponse;

public class ListCollaborationConfiguredAudienceModelAssociationsIterable
implements SdkIterable<ListCollaborationConfiguredAudienceModelAssociationsResponse> {
    private final CleanRoomsClient client;
    private final ListCollaborationConfiguredAudienceModelAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationConfiguredAudienceModelAssociationsIterable(CleanRoomsClient client, ListCollaborationConfiguredAudienceModelAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationConfiguredAudienceModelAssociationsResponseFetcher();
    }

    public Iterator<ListCollaborationConfiguredAudienceModelAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationConfiguredAudienceModelAssociationSummary> collaborationConfiguredAudienceModelAssociationSummaries() {
        Function<ListCollaborationConfiguredAudienceModelAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationConfiguredAudienceModelAssociationSummaries() != null) {
                return response.collaborationConfiguredAudienceModelAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationConfiguredAudienceModelAssociationsResponseFetcher
    implements SyncPageFetcher<ListCollaborationConfiguredAudienceModelAssociationsResponse> {
        private ListCollaborationConfiguredAudienceModelAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationConfiguredAudienceModelAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationConfiguredAudienceModelAssociationsResponse nextPage(ListCollaborationConfiguredAudienceModelAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationConfiguredAudienceModelAssociationsIterable.this.client.listCollaborationConfiguredAudienceModelAssociations(ListCollaborationConfiguredAudienceModelAssociationsIterable.this.firstRequest);
            }
            return ListCollaborationConfiguredAudienceModelAssociationsIterable.this.client.listCollaborationConfiguredAudienceModelAssociations((ListCollaborationConfiguredAudienceModelAssociationsRequest)((Object)ListCollaborationConfiguredAudienceModelAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

