/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudcontrol.model.HandlerErrorCode;
import software.amazon.awssdk.services.cloudcontrol.model.Operation;
import software.amazon.awssdk.services.cloudcontrol.model.OperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProgressEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProgressEvent> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(ProgressEvent.getter(ProgressEvent::typeName)).setter(ProgressEvent.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(ProgressEvent.getter(ProgressEvent::identifier)).setter(ProgressEvent.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestToken").getter(ProgressEvent.getter(ProgressEvent::requestToken)).setter(ProgressEvent.setter(Builder::requestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestToken").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(ProgressEvent.getter(ProgressEvent::operationAsString)).setter(ProgressEvent.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<String> OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationStatus").getter(ProgressEvent.getter(ProgressEvent::operationStatusAsString)).setter(ProgressEvent.setter(Builder::operationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatus").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTime").getter(ProgressEvent.getter(ProgressEvent::eventTime)).setter(ProgressEvent.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()}).build();
    private static final SdkField<String> RESOURCE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceModel").getter(ProgressEvent.getter(ProgressEvent::resourceModel)).setter(ProgressEvent.setter(Builder::resourceModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceModel").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ProgressEvent.getter(ProgressEvent::statusMessage)).setter(ProgressEvent.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(ProgressEvent.getter(ProgressEvent::errorCodeAsString)).setter(ProgressEvent.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<Instant> RETRY_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RetryAfter").getter(ProgressEvent.getter(ProgressEvent::retryAfter)).setter(ProgressEvent.setter(Builder::retryAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, IDENTIFIER_FIELD, REQUEST_TOKEN_FIELD, OPERATION_FIELD, OPERATION_STATUS_FIELD, EVENT_TIME_FIELD, RESOURCE_MODEL_FIELD, STATUS_MESSAGE_FIELD, ERROR_CODE_FIELD, RETRY_AFTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String typeName;
    private final String identifier;
    private final String requestToken;
    private final String operation;
    private final String operationStatus;
    private final Instant eventTime;
    private final String resourceModel;
    private final String statusMessage;
    private final String errorCode;
    private final Instant retryAfter;

    private ProgressEvent(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.identifier = builder.identifier;
        this.requestToken = builder.requestToken;
        this.operation = builder.operation;
        this.operationStatus = builder.operationStatus;
        this.eventTime = builder.eventTime;
        this.resourceModel = builder.resourceModel;
        this.statusMessage = builder.statusMessage;
        this.errorCode = builder.errorCode;
        this.retryAfter = builder.retryAfter;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String requestToken() {
        return this.requestToken;
    }

    public final Operation operation() {
        return Operation.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final OperationStatus operationStatus() {
        return OperationStatus.fromValue(this.operationStatus);
    }

    public final String operationStatusAsString() {
        return this.operationStatus;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String resourceModel() {
        return this.resourceModel;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final HandlerErrorCode errorCode() {
        return HandlerErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final Instant retryAfter() {
        return this.retryAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgressEvent)) {
            return false;
        }
        ProgressEvent other = (ProgressEvent)obj;
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.requestToken(), other.requestToken()) && Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.operationStatusAsString(), other.operationStatusAsString()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.resourceModel(), other.resourceModel()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.retryAfter(), other.retryAfter());
    }

    public final String toString() {
        return ToString.builder((String)"ProgressEvent").add("TypeName", (Object)this.typeName()).add("Identifier", (Object)this.identifier()).add("RequestToken", (Object)this.requestToken()).add("Operation", (Object)this.operationAsString()).add("OperationStatus", (Object)this.operationStatusAsString()).add("EventTime", (Object)this.eventTime()).add("ResourceModel", (Object)(this.resourceModel() == null ? null : "*** Sensitive Data Redacted ***")).add("StatusMessage", (Object)this.statusMessage()).add("ErrorCode", (Object)this.errorCodeAsString()).add("RetryAfter", (Object)this.retryAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "RequestToken": {
                return Optional.ofNullable(clazz.cast(this.requestToken()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "OperationStatus": {
                return Optional.ofNullable(clazz.cast(this.operationStatusAsString()));
            }
            case "EventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "ResourceModel": {
                return Optional.ofNullable(clazz.cast(this.resourceModel()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "RetryAfter": {
                return Optional.ofNullable(clazz.cast(this.retryAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProgressEvent, T> g) {
        return obj -> g.apply((ProgressEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String identifier;
        private String requestToken;
        private String operation;
        private String operationStatus;
        private Instant eventTime;
        private String resourceModel;
        private String statusMessage;
        private String errorCode;
        private Instant retryAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgressEvent model) {
            this.typeName(model.typeName);
            this.identifier(model.identifier);
            this.requestToken(model.requestToken);
            this.operation(model.operation);
            this.operationStatus(model.operationStatus);
            this.eventTime(model.eventTime);
            this.resourceModel(model.resourceModel);
            this.statusMessage(model.statusMessage);
            this.errorCode(model.errorCode);
            this.retryAfter(model.retryAfter);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRequestToken() {
            return this.requestToken;
        }

        public final void setRequestToken(String requestToken) {
            this.requestToken = requestToken;
        }

        @Override
        public final Builder requestToken(String requestToken) {
            this.requestToken = requestToken;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final String getOperationStatus() {
            return this.operationStatus;
        }

        public final void setOperationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
        }

        @Override
        public final Builder operationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
            return this;
        }

        @Override
        public final Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus(operationStatus == null ? null : operationStatus.toString());
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getResourceModel() {
            return this.resourceModel;
        }

        public final void setResourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
        }

        @Override
        public final Builder resourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(HandlerErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final Instant getRetryAfter() {
            return this.retryAfter;
        }

        public final void setRetryAfter(Instant retryAfter) {
            this.retryAfter = retryAfter;
        }

        @Override
        public final Builder retryAfter(Instant retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public ProgressEvent build() {
            return new ProgressEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProgressEvent> {
        public Builder typeName(String var1);

        public Builder identifier(String var1);

        public Builder requestToken(String var1);

        public Builder operation(String var1);

        public Builder operation(Operation var1);

        public Builder operationStatus(String var1);

        public Builder operationStatus(OperationStatus var1);

        public Builder eventTime(Instant var1);

        public Builder resourceModel(String var1);

        public Builder statusMessage(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(HandlerErrorCode var1);

        public Builder retryAfter(Instant var1);
    }
}

