/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueryStatus {
    QUEUED("QUEUED"),
    RUNNING("RUNNING"),
    FINISHED("FINISHED"),
    FAILED("FAILED"),
    CANCELLED("CANCELLED"),
    TIMED_OUT("TIMED_OUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueryStatus> VALUE_MAP;
    private final String value;

    private QueryStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueryStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueryStatus> knownValues() {
        EnumSet<QueryStatus> knownValues = EnumSet.allOf(QueryStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueryStatus.class, QueryStatus::toString);
    }
}

