/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.FleetContextCode;
import software.amazon.awssdk.services.codebuild.model.FleetStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetStatus> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(FleetStatus.getter(FleetStatus::statusCodeAsString)).setter(FleetStatus.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("context").getter(FleetStatus.getter(FleetStatus::contextAsString)).setter(FleetStatus.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(FleetStatus.getter(FleetStatus::message)).setter(FleetStatus.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD, CONTEXT_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String statusCodeValue;
    private final String context;
    private final String message;

    private FleetStatus(BuilderImpl builder) {
        this.statusCodeValue = builder.statusCodeValue;
        this.context = builder.context;
        this.message = builder.message;
    }

    public final FleetStatusCode statusCode() {
        return FleetStatusCode.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public final FleetContextCode context() {
        return FleetContextCode.fromValue(this.context);
    }

    public final String contextAsString() {
        return this.context;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetStatus)) {
            return false;
        }
        FleetStatus other = (FleetStatus)obj;
        return Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.contextAsString(), other.contextAsString()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"FleetStatus").add("StatusCode", (Object)this.statusCodeAsString()).add("Context", (Object)this.contextAsString()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "context": {
                return Optional.ofNullable(clazz.cast(this.contextAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetStatus, T> g) {
        return obj -> g.apply((FleetStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String statusCodeValue;
        private String context;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetStatus model) {
            this.statusCode(model.statusCodeValue);
            this.context(model.context);
            this.message(model.message);
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(FleetStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public final Builder context(FleetContextCode context) {
            this.context(context == null ? null : context.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public FleetStatus build() {
            return new FleetStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetStatus> {
        public Builder statusCode(String var1);

        public Builder statusCode(FleetStatusCode var1);

        public Builder context(String var1);

        public Builder context(FleetContextCode var1);

        public Builder message(String var1);
    }
}

