/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ReportGroupTrendFieldType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReportGroupTrendRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, GetReportGroupTrendRequest> {
    private static final SdkField<String> REPORT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportGroupArn").getter(GetReportGroupTrendRequest.getter(GetReportGroupTrendRequest::reportGroupArn)).setter(GetReportGroupTrendRequest.setter(Builder::reportGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroupArn").build()}).build();
    private static final SdkField<Integer> NUM_OF_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numOfReports").getter(GetReportGroupTrendRequest.getter(GetReportGroupTrendRequest::numOfReports)).setter(GetReportGroupTrendRequest.setter(Builder::numOfReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numOfReports").build()}).build();
    private static final SdkField<String> TREND_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trendField").getter(GetReportGroupTrendRequest.getter(GetReportGroupTrendRequest::trendFieldAsString)).setter(GetReportGroupTrendRequest.setter(Builder::trendField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trendField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GROUP_ARN_FIELD, NUM_OF_REPORTS_FIELD, TREND_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetReportGroupTrendRequest.memberNameToFieldInitializer();
    private final String reportGroupArn;
    private final Integer numOfReports;
    private final String trendField;

    private GetReportGroupTrendRequest(BuilderImpl builder) {
        super(builder);
        this.reportGroupArn = builder.reportGroupArn;
        this.numOfReports = builder.numOfReports;
        this.trendField = builder.trendField;
    }

    public final String reportGroupArn() {
        return this.reportGroupArn;
    }

    public final Integer numOfReports() {
        return this.numOfReports;
    }

    public final ReportGroupTrendFieldType trendField() {
        return ReportGroupTrendFieldType.fromValue(this.trendField);
    }

    public final String trendFieldAsString() {
        return this.trendField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.numOfReports());
        hashCode = 31 * hashCode + Objects.hashCode(this.trendFieldAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReportGroupTrendRequest)) {
            return false;
        }
        GetReportGroupTrendRequest other = (GetReportGroupTrendRequest)((Object)obj);
        return Objects.equals(this.reportGroupArn(), other.reportGroupArn()) && Objects.equals(this.numOfReports(), other.numOfReports()) && Objects.equals(this.trendFieldAsString(), other.trendFieldAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetReportGroupTrendRequest").add("ReportGroupArn", (Object)this.reportGroupArn()).add("NumOfReports", (Object)this.numOfReports()).add("TrendField", (Object)this.trendFieldAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportGroupArn": {
                return Optional.ofNullable(clazz.cast(this.reportGroupArn()));
            }
            case "numOfReports": {
                return Optional.ofNullable(clazz.cast(this.numOfReports()));
            }
            case "trendField": {
                return Optional.ofNullable(clazz.cast(this.trendFieldAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reportGroupArn", REPORT_GROUP_ARN_FIELD);
        map.put("numOfReports", NUM_OF_REPORTS_FIELD);
        map.put("trendField", TREND_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReportGroupTrendRequest, T> g) {
        return obj -> g.apply((GetReportGroupTrendRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String reportGroupArn;
        private Integer numOfReports;
        private String trendField;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReportGroupTrendRequest model) {
            super(model);
            this.reportGroupArn(model.reportGroupArn);
            this.numOfReports(model.numOfReports);
            this.trendField(model.trendField);
        }

        public final String getReportGroupArn() {
            return this.reportGroupArn;
        }

        public final void setReportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
        }

        @Override
        public final Builder reportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
            return this;
        }

        public final Integer getNumOfReports() {
            return this.numOfReports;
        }

        public final void setNumOfReports(Integer numOfReports) {
            this.numOfReports = numOfReports;
        }

        @Override
        public final Builder numOfReports(Integer numOfReports) {
            this.numOfReports = numOfReports;
            return this;
        }

        public final String getTrendField() {
            return this.trendField;
        }

        public final void setTrendField(String trendField) {
            this.trendField = trendField;
        }

        @Override
        public final Builder trendField(String trendField) {
            this.trendField = trendField;
            return this;
        }

        @Override
        public final Builder trendField(ReportGroupTrendFieldType trendField) {
            this.trendField(trendField == null ? null : trendField.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReportGroupTrendRequest build() {
            return new GetReportGroupTrendRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReportGroupTrendRequest> {
        public Builder reportGroupArn(String var1);

        public Builder numOfReports(Integer var1);

        public Builder trendField(String var1);

        public Builder trendField(ReportGroupTrendFieldType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

