/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesItem;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesResponse;

public class ListSourceRepositoryBranchesIterable
implements SdkIterable<ListSourceRepositoryBranchesResponse> {
    private final CodeCatalystClient client;
    private final ListSourceRepositoryBranchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSourceRepositoryBranchesIterable(CodeCatalystClient client, ListSourceRepositoryBranchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSourceRepositoryBranchesResponseFetcher();
    }

    public Iterator<ListSourceRepositoryBranchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListSourceRepositoryBranchesItem> items() {
        Function<ListSourceRepositoryBranchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSourceRepositoryBranchesResponseFetcher
    implements SyncPageFetcher<ListSourceRepositoryBranchesResponse> {
        private ListSourceRepositoryBranchesResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceRepositoryBranchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSourceRepositoryBranchesResponse nextPage(ListSourceRepositoryBranchesResponse previousPage) {
            if (previousPage == null) {
                return ListSourceRepositoryBranchesIterable.this.client.listSourceRepositoryBranches(ListSourceRepositoryBranchesIterable.this.firstRequest);
            }
            return ListSourceRepositoryBranchesIterable.this.client.listSourceRepositoryBranches((ListSourceRepositoryBranchesRequest)((Object)ListSourceRepositoryBranchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

