/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesItem;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesResponse;

public class ListSourceRepositoryBranchesPublisher
implements SdkPublisher<ListSourceRepositoryBranchesResponse> {
    private final CodeCatalystAsyncClient client;
    private final ListSourceRepositoryBranchesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSourceRepositoryBranchesPublisher(CodeCatalystAsyncClient client, ListSourceRepositoryBranchesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSourceRepositoryBranchesPublisher(CodeCatalystAsyncClient client, ListSourceRepositoryBranchesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSourceRepositoryBranchesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSourceRepositoryBranchesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListSourceRepositoryBranchesItem> items() {
        Function<ListSourceRepositoryBranchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSourceRepositoryBranchesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSourceRepositoryBranchesResponseFetcher
    implements AsyncPageFetcher<ListSourceRepositoryBranchesResponse> {
        private ListSourceRepositoryBranchesResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceRepositoryBranchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSourceRepositoryBranchesResponse> nextPage(ListSourceRepositoryBranchesResponse previousPage) {
            if (previousPage == null) {
                return ListSourceRepositoryBranchesPublisher.this.client.listSourceRepositoryBranches(ListSourceRepositoryBranchesPublisher.this.firstRequest);
            }
            return ListSourceRepositoryBranchesPublisher.this.client.listSourceRepositoryBranches((ListSourceRepositoryBranchesRequest)((Object)ListSourceRepositoryBranchesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

