/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecatalyst.model.EventLogEntry;
import software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListEventLogsResponse;

public class ListEventLogsIterable
implements SdkIterable<ListEventLogsResponse> {
    private final CodeCatalystClient client;
    private final ListEventLogsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventLogsIterable(CodeCatalystClient client, ListEventLogsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventLogsResponseFetcher();
    }

    public Iterator<ListEventLogsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventLogEntry> items() {
        Function<ListEventLogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventLogsResponseFetcher
    implements SyncPageFetcher<ListEventLogsResponse> {
        private ListEventLogsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventLogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventLogsResponse nextPage(ListEventLogsResponse previousPage) {
            if (previousPage == null) {
                return ListEventLogsIterable.this.client.listEventLogs(ListEventLogsIterable.this.firstRequest);
            }
            return ListEventLogsIterable.this.client.listEventLogs((ListEventLogsRequest)((Object)ListEventLogsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

