/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo;
import software.amazon.awssdk.services.codedeploy.model.TargetGroupInfoListCopier;
import software.amazon.awssdk.services.codedeploy.model.TrafficRoute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetGroupPairInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetGroupPairInfo> {
    private static final SdkField<List<TargetGroupInfo>> TARGET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetGroups").getter(TargetGroupPairInfo.getter(TargetGroupPairInfo::targetGroups)).setter(TargetGroupPairInfo.setter(Builder::targetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TrafficRoute> PROD_TRAFFIC_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("prodTrafficRoute").getter(TargetGroupPairInfo.getter(TargetGroupPairInfo::prodTrafficRoute)).setter(TargetGroupPairInfo.setter(Builder::prodTrafficRoute)).constructor(TrafficRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prodTrafficRoute").build()}).build();
    private static final SdkField<TrafficRoute> TEST_TRAFFIC_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testTrafficRoute").getter(TargetGroupPairInfo.getter(TargetGroupPairInfo::testTrafficRoute)).setter(TargetGroupPairInfo.setter(Builder::testTrafficRoute)).constructor(TrafficRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testTrafficRoute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUPS_FIELD, PROD_TRAFFIC_ROUTE_FIELD, TEST_TRAFFIC_ROUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetGroupPairInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<TargetGroupInfo> targetGroups;
    private final TrafficRoute prodTrafficRoute;
    private final TrafficRoute testTrafficRoute;

    private TargetGroupPairInfo(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
        this.prodTrafficRoute = builder.prodTrafficRoute;
        this.testTrafficRoute = builder.testTrafficRoute;
    }

    public final boolean hasTargetGroups() {
        return this.targetGroups != null && !(this.targetGroups instanceof SdkAutoConstructList);
    }

    public final List<TargetGroupInfo> targetGroups() {
        return this.targetGroups;
    }

    public final TrafficRoute prodTrafficRoute() {
        return this.prodTrafficRoute;
    }

    public final TrafficRoute testTrafficRoute() {
        return this.testTrafficRoute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroups() ? this.targetGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.prodTrafficRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.testTrafficRoute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupPairInfo)) {
            return false;
        }
        TargetGroupPairInfo other = (TargetGroupPairInfo)obj;
        return this.hasTargetGroups() == other.hasTargetGroups() && Objects.equals(this.targetGroups(), other.targetGroups()) && Objects.equals(this.prodTrafficRoute(), other.prodTrafficRoute()) && Objects.equals(this.testTrafficRoute(), other.testTrafficRoute());
    }

    public final String toString() {
        return ToString.builder((String)"TargetGroupPairInfo").add("TargetGroups", this.hasTargetGroups() ? this.targetGroups() : null).add("ProdTrafficRoute", (Object)this.prodTrafficRoute()).add("TestTrafficRoute", (Object)this.testTrafficRoute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetGroups": {
                return Optional.ofNullable(clazz.cast(this.targetGroups()));
            }
            case "prodTrafficRoute": {
                return Optional.ofNullable(clazz.cast(this.prodTrafficRoute()));
            }
            case "testTrafficRoute": {
                return Optional.ofNullable(clazz.cast(this.testTrafficRoute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetGroups", TARGET_GROUPS_FIELD);
        map.put("prodTrafficRoute", PROD_TRAFFIC_ROUTE_FIELD);
        map.put("testTrafficRoute", TEST_TRAFFIC_ROUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupPairInfo, T> g) {
        return obj -> g.apply((TargetGroupPairInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TargetGroupInfo> targetGroups = DefaultSdkAutoConstructList.getInstance();
        private TrafficRoute prodTrafficRoute;
        private TrafficRoute testTrafficRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupPairInfo model) {
            this.targetGroups(model.targetGroups);
            this.prodTrafficRoute(model.prodTrafficRoute);
            this.testTrafficRoute(model.testTrafficRoute);
        }

        public final List<TargetGroupInfo.Builder> getTargetGroups() {
            List<TargetGroupInfo.Builder> result = TargetGroupInfoListCopier.copyToBuilder(this.targetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetGroups(Collection<TargetGroupInfo.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupInfoListCopier.copyFromBuilder(targetGroups);
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroupInfo> targetGroups) {
            this.targetGroups = TargetGroupInfoListCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroupInfo ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<TargetGroupInfo.Builder> ... targetGroups) {
            this.targetGroups(Stream.of(targetGroups).map(c -> (TargetGroupInfo)((TargetGroupInfo.Builder)TargetGroupInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TrafficRoute.Builder getProdTrafficRoute() {
            return this.prodTrafficRoute != null ? this.prodTrafficRoute.toBuilder() : null;
        }

        public final void setProdTrafficRoute(TrafficRoute.BuilderImpl prodTrafficRoute) {
            this.prodTrafficRoute = prodTrafficRoute != null ? prodTrafficRoute.build() : null;
        }

        @Override
        public final Builder prodTrafficRoute(TrafficRoute prodTrafficRoute) {
            this.prodTrafficRoute = prodTrafficRoute;
            return this;
        }

        public final TrafficRoute.Builder getTestTrafficRoute() {
            return this.testTrafficRoute != null ? this.testTrafficRoute.toBuilder() : null;
        }

        public final void setTestTrafficRoute(TrafficRoute.BuilderImpl testTrafficRoute) {
            this.testTrafficRoute = testTrafficRoute != null ? testTrafficRoute.build() : null;
        }

        @Override
        public final Builder testTrafficRoute(TrafficRoute testTrafficRoute) {
            this.testTrafficRoute = testTrafficRoute;
            return this;
        }

        public TargetGroupPairInfo build() {
            return new TargetGroupPairInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetGroupPairInfo> {
        public Builder targetGroups(Collection<TargetGroupInfo> var1);

        public Builder targetGroups(TargetGroupInfo ... var1);

        public Builder targetGroups(Consumer<TargetGroupInfo.Builder> ... var1);

        public Builder prodTrafficRoute(TrafficRoute var1);

        default public Builder prodTrafficRoute(Consumer<TrafficRoute.Builder> prodTrafficRoute) {
            return this.prodTrafficRoute((TrafficRoute)((TrafficRoute.Builder)TrafficRoute.builder().applyMutation(prodTrafficRoute)).build());
        }

        public Builder testTrafficRoute(TrafficRoute var1);

        default public Builder testTrafficRoute(Consumer<TrafficRoute.Builder> testTrafficRoute) {
            return this.testTrafficRoute((TrafficRoute)((TrafficRoute.Builder)TrafficRoute.builder().applyMutation(testTrafficRoute)).build());
        }
    }
}

