/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary;
import software.amazon.awssdk.services.codedeploy.model.TimeBasedLinear;
import software.amazon.awssdk.services.codedeploy.model.TrafficRoutingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficRoutingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficRoutingConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(TrafficRoutingConfig.getter(TrafficRoutingConfig::typeAsString)).setter(TrafficRoutingConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<TimeBasedCanary> TIME_BASED_CANARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeBasedCanary").getter(TrafficRoutingConfig.getter(TrafficRoutingConfig::timeBasedCanary)).setter(TrafficRoutingConfig.setter(Builder::timeBasedCanary)).constructor(TimeBasedCanary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeBasedCanary").build()}).build();
    private static final SdkField<TimeBasedLinear> TIME_BASED_LINEAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeBasedLinear").getter(TrafficRoutingConfig.getter(TrafficRoutingConfig::timeBasedLinear)).setter(TrafficRoutingConfig.setter(Builder::timeBasedLinear)).constructor(TimeBasedLinear::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeBasedLinear").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TIME_BASED_CANARY_FIELD, TIME_BASED_LINEAR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrafficRoutingConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final TimeBasedCanary timeBasedCanary;
    private final TimeBasedLinear timeBasedLinear;

    private TrafficRoutingConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.timeBasedCanary = builder.timeBasedCanary;
        this.timeBasedLinear = builder.timeBasedLinear;
    }

    public final TrafficRoutingType type() {
        return TrafficRoutingType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final TimeBasedCanary timeBasedCanary() {
        return this.timeBasedCanary;
    }

    public final TimeBasedLinear timeBasedLinear() {
        return this.timeBasedLinear;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeBasedCanary());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeBasedLinear());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficRoutingConfig)) {
            return false;
        }
        TrafficRoutingConfig other = (TrafficRoutingConfig)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.timeBasedCanary(), other.timeBasedCanary()) && Objects.equals(this.timeBasedLinear(), other.timeBasedLinear());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficRoutingConfig").add("Type", (Object)this.typeAsString()).add("TimeBasedCanary", (Object)this.timeBasedCanary()).add("TimeBasedLinear", (Object)this.timeBasedLinear()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "timeBasedCanary": {
                return Optional.ofNullable(clazz.cast(this.timeBasedCanary()));
            }
            case "timeBasedLinear": {
                return Optional.ofNullable(clazz.cast(this.timeBasedLinear()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("timeBasedCanary", TIME_BASED_CANARY_FIELD);
        map.put("timeBasedLinear", TIME_BASED_LINEAR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficRoutingConfig, T> g) {
        return obj -> g.apply((TrafficRoutingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private TimeBasedCanary timeBasedCanary;
        private TimeBasedLinear timeBasedLinear;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficRoutingConfig model) {
            this.type(model.type);
            this.timeBasedCanary(model.timeBasedCanary);
            this.timeBasedLinear(model.timeBasedLinear);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TrafficRoutingType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TimeBasedCanary.Builder getTimeBasedCanary() {
            return this.timeBasedCanary != null ? this.timeBasedCanary.toBuilder() : null;
        }

        public final void setTimeBasedCanary(TimeBasedCanary.BuilderImpl timeBasedCanary) {
            this.timeBasedCanary = timeBasedCanary != null ? timeBasedCanary.build() : null;
        }

        @Override
        public final Builder timeBasedCanary(TimeBasedCanary timeBasedCanary) {
            this.timeBasedCanary = timeBasedCanary;
            return this;
        }

        public final TimeBasedLinear.Builder getTimeBasedLinear() {
            return this.timeBasedLinear != null ? this.timeBasedLinear.toBuilder() : null;
        }

        public final void setTimeBasedLinear(TimeBasedLinear.BuilderImpl timeBasedLinear) {
            this.timeBasedLinear = timeBasedLinear != null ? timeBasedLinear.build() : null;
        }

        @Override
        public final Builder timeBasedLinear(TimeBasedLinear timeBasedLinear) {
            this.timeBasedLinear = timeBasedLinear;
            return this;
        }

        public TrafficRoutingConfig build() {
            return new TrafficRoutingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficRoutingConfig> {
        public Builder type(String var1);

        public Builder type(TrafficRoutingType var1);

        public Builder timeBasedCanary(TimeBasedCanary var1);

        default public Builder timeBasedCanary(Consumer<TimeBasedCanary.Builder> timeBasedCanary) {
            return this.timeBasedCanary((TimeBasedCanary)((TimeBasedCanary.Builder)TimeBasedCanary.builder().applyMutation(timeBasedCanary)).build());
        }

        public Builder timeBasedLinear(TimeBasedLinear var1);

        default public Builder timeBasedLinear(Consumer<TimeBasedLinear.Builder> timeBasedLinear) {
            return this.timeBasedLinear((TimeBasedLinear)((TimeBasedLinear.Builder)TimeBasedLinear.builder().applyMutation(timeBasedLinear)).build());
        }
    }
}

