/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.time.ZonedDateTime;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.Utils;
import software.amazon.awssdk.codegen.lite.emitters.CodeWriter;
import software.amazon.awssdk.utils.IoUtils;

public final class CodeGenerator {
    private final Writer writer;
    private final PoetClass poetClass;

    public CodeGenerator(String outputDirectory, PoetClass poetClass) {
        this.writer = new CodeWriter(outputDirectory, poetClass.className().simpleName());
        this.poetClass = poetClass;
    }

    public void generate() {
        try {
            this.writer.write(this.loadDefaultFileHeader() + "\n");
            JavaFile.builder((String)this.poetClass.className().packageName(), (TypeSpec)this.poetClass.poetClass()).skipJavaLangImports(true).build().writeTo((Appendable)this.writer);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error creating class %s", this.poetClass.className().simpleName()), e);
        }
        finally {
            Utils.closeQuietly(this.writer);
        }
    }

    private String loadDefaultFileHeader() throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/software/amazon/awssdk/codegen/lite/DefaultFileHeader.txt");){
            String string = IoUtils.toUtf8String((InputStream)inputStream).replaceFirst("%COPYRIGHT_DATE_RANGE%", this.getCopyrightDateRange());
            return string;
        }
    }

    private String getCopyrightDateRange() {
        int currentYear = ZonedDateTime.now().getYear();
        int copyrightStartYear = currentYear - 5;
        return String.format("%d-%d", copyrightStartYear, currentYear);
    }
}

