/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.Utils;
import software.amazon.awssdk.codegen.lite.regions.model.Partition;
import software.amazon.awssdk.utils.ImmutableMap;

public class PartitionMetadataGenerator
implements PoetClass {
    private final Partition partition;
    private final String basePackage;
    private final String regionBasePackage;

    public PartitionMetadataGenerator(Partition partition, String basePackage, String regionBasePackage) {
        this.partition = partition;
        this.basePackage = basePackage;
        this.regionBasePackage = regionBasePackage;
    }

    @Override
    public TypeSpec poetClass() {
        ParameterizedTypeName mapByPartitionEndpointKey = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.partitionEndpointKeyClass(), ClassName.get(String.class)});
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get((String)this.regionBasePackage, (String)"PartitionMetadata", (String[])new String[0])).addAnnotation(SdkPublicApi.class).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addField(FieldSpec.builder((TypeName)mapByPartitionEndpointKey, (String)"DNS_SUFFIXES", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.dnsSuffixes()).build()).addField(FieldSpec.builder((TypeName)mapByPartitionEndpointKey, (String)"HOSTNAMES", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.hostnames()).build()).addField(FieldSpec.builder(String.class, (String)"ID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.partition.getPartition()}).build()).addField(FieldSpec.builder(String.class, (String)"NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.partition.getPartitionName()}).build()).addField(FieldSpec.builder(String.class, (String)"REGION_REGEX", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.partition.getRegionRegex()}).build()).addMethod(this.getter("id", "ID")).addMethod(this.getter("name", "NAME")).addMethod(this.getter("regionRegex", "REGION_REGEX")).addMethod(this.dnsSuffixGetter()).addMethod(this.hostnameGetter()).build();
    }

    private CodeBlock dnsSuffixes() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<$T, $T>builder()", new Object[]{ImmutableMap.class, this.partitionEndpointKeyClass(), String.class});
        builder.add(".put(", new Object[0]).add(this.partitionEndpointKey(Collections.emptyList())).add(", $S)", new Object[]{this.partition.getDnsSuffix()});
        if (this.partition.getDefaults() != null) {
            this.partition.getDefaults().getVariants().forEach(variant -> {
                if (variant.getDnsSuffix() != null) {
                    builder.add(".put(", new Object[0]).add(this.partitionEndpointKey(variant.getTags())).add(", $S)", new Object[]{variant.getDnsSuffix()});
                }
            });
        }
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock hostnames() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<$T, $T>builder()", new Object[]{ImmutableMap.class, this.partitionEndpointKeyClass(), String.class});
        if (this.partition.getDefaults() != null) {
            builder.add(".put(", new Object[0]).add(this.partitionEndpointKey(Collections.emptyList())).add(", $S)", new Object[]{this.partition.getDefaults().getHostname()});
            this.partition.getDefaults().getVariants().forEach(variant -> {
                if (variant.getHostname() != null) {
                    builder.add(".put(", new Object[0]).add(this.partitionEndpointKey(variant.getTags())).add(", $S)", new Object[]{variant.getHostname()});
                }
            });
        }
        return builder.add(".build()", new Object[0]).build();
    }

    private MethodSpec dnsSuffixGetter() {
        return MethodSpec.methodBuilder((String)"dnsSuffix").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addParameter((TypeName)this.partitionEndpointKeyClass(), "key", new Modifier[0]).addStatement("return DNS_SUFFIXES.get(key)", new Object[0]).build();
    }

    private MethodSpec hostnameGetter() {
        return MethodSpec.methodBuilder((String)"hostname").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addParameter((TypeName)this.partitionEndpointKeyClass(), "key", new Modifier[0]).addStatement("return HOSTNAMES.get(key)", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.basePackage, (String)(Stream.of(this.partition.getPartition().split("-")).map(Utils::capitalize).collect(Collectors.joining()) + "PartitionMetadata"), (String[])new String[0]);
    }

    private MethodSpec getter(String methodName, String field) {
        return MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $L", new Object[]{field}).build();
    }

    private CodeBlock partitionEndpointKey(Collection<String> tags) {
        CodeBlock.Builder result = CodeBlock.builder();
        result.add("$T.builder()", new Object[]{this.partitionEndpointKeyClass()});
        if (!tags.isEmpty()) {
            CodeBlock tagsParameter = (CodeBlock)tags.stream().map(tag -> CodeBlock.of((String)"$T.of($S)", (Object[])new Object[]{this.endpointTagClass(), tag})).collect(CodeBlock.joining((String)", "));
            result.add(".tags(", new Object[0]).add(tagsParameter).add(")", new Object[0]);
        }
        result.add(".build()", new Object[0]);
        return result.build();
    }

    private ClassName endpointTagClass() {
        return ClassName.get((String)this.regionBasePackage, (String)"EndpointTag", (String[])new String[0]);
    }

    private ClassName partitionEndpointKeyClass() {
        return ClassName.get((String)this.regionBasePackage, (String)"PartitionEndpointKey", (String[])new String[0]);
    }
}

