/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeguruprofiler.model.ActionGroup;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemovePermissionRequest
extends CodeGuruProfilerRequest
implements ToCopyableBuilder<Builder, RemovePermissionRequest> {
    private static final SdkField<String> ACTION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroup").getter(RemovePermissionRequest.getter(RemovePermissionRequest::actionGroupAsString)).setter(RemovePermissionRequest.setter(Builder::actionGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("actionGroup").build()}).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profilingGroupName").getter(RemovePermissionRequest.getter(RemovePermissionRequest::profilingGroupName)).setter(RemovePermissionRequest.setter(Builder::profilingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(RemovePermissionRequest.getter(RemovePermissionRequest::revisionId)).setter(RemovePermissionRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("revisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_FIELD, PROFILING_GROUP_NAME_FIELD, REVISION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionGroup", ACTION_GROUP_FIELD);
            this.put("profilingGroupName", PROFILING_GROUP_NAME_FIELD);
            this.put("revisionId", REVISION_ID_FIELD);
        }
    });
    private final String actionGroup;
    private final String profilingGroupName;
    private final String revisionId;

    private RemovePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.actionGroup = builder.actionGroup;
        this.profilingGroupName = builder.profilingGroupName;
        this.revisionId = builder.revisionId;
    }

    public final ActionGroup actionGroup() {
        return ActionGroup.fromValue(this.actionGroup);
    }

    public final String actionGroupAsString() {
        return this.actionGroup;
    }

    public final String profilingGroupName() {
        return this.profilingGroupName;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionRequest)) {
            return false;
        }
        RemovePermissionRequest other = (RemovePermissionRequest)((Object)obj);
        return Objects.equals(this.actionGroupAsString(), other.actionGroupAsString()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"RemovePermissionRequest").add("ActionGroup", (Object)this.actionGroupAsString()).add("ProfilingGroupName", (Object)this.profilingGroupName()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroup": {
                return Optional.ofNullable(clazz.cast(this.actionGroupAsString()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemovePermissionRequest, T> g) {
        return obj -> g.apply((RemovePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerRequest.BuilderImpl
    implements Builder {
        private String actionGroup;
        private String profilingGroupName;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionRequest model) {
            super(model);
            this.actionGroup(model.actionGroup);
            this.profilingGroupName(model.profilingGroupName);
            this.revisionId(model.revisionId);
        }

        public final String getActionGroup() {
            return this.actionGroup;
        }

        public final void setActionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
        }

        @Override
        public final Builder actionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
            return this;
        }

        @Override
        public final Builder actionGroup(ActionGroup actionGroup) {
            this.actionGroup(actionGroup == null ? null : actionGroup.toString());
            return this;
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemovePermissionRequest build() {
            return new RemovePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemovePermissionRequest> {
        public Builder actionGroup(String var1);

        public Builder actionGroup(ActionGroup var1);

        public Builder profilingGroupName(String var1);

        public Builder revisionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

