/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.CodePipelineServiceClientConfiguration;
import software.amazon.awssdk.services.codepipeline.internal.CodePipelineServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse;
import software.amazon.awssdk.services.codepipeline.model.ActionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ApprovalAlreadyCompletedException;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineException;
import software.amazon.awssdk.services.codepipeline.model.ConcurrentModificationException;
import software.amazon.awssdk.services.codepipeline.model.ConcurrentPipelineExecutionsLimitExceededException;
import software.amazon.awssdk.services.codepipeline.model.ConflictException;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.DuplicatedStopRequestException;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.GetActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.InvalidActionDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidApprovalTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidArnException;
import software.amazon.awssdk.services.codepipeline.model.InvalidBlockerDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidClientTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobStateException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNonceException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStageDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStructureException;
import software.amazon.awssdk.services.codepipeline.model.InvalidTagsException;
import software.amazon.awssdk.services.codepipeline.model.InvalidWebhookAuthenticationParametersException;
import software.amazon.awssdk.services.codepipeline.model.InvalidWebhookFilterPatternException;
import software.amazon.awssdk.services.codepipeline.model.JobNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.LimitExceededException;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse;
import software.amazon.awssdk.services.codepipeline.model.NotLatestPipelineExecutionException;
import software.amazon.awssdk.services.codepipeline.model.OutputVariablesSizeExceededException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionNotStoppableException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionOutdatedException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNameInUseException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineVersionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.RequestFailedException;
import software.amazon.awssdk.services.codepipeline.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest;
import software.amazon.awssdk.services.codepipeline.model.RollbackStageResponse;
import software.amazon.awssdk.services.codepipeline.model.StageNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.StageNotRetryableException;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.TagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.TagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.TooManyTagsException;
import software.amazon.awssdk.services.codepipeline.model.UnableToRollbackStageException;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.ValidationException;
import software.amazon.awssdk.services.codepipeline.model.WebhookNotFoundException;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeThirdPartyJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreateCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteWebhookRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeregisterWebhookWithThirdPartyRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DisableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.EnableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineStateRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetThirdPartyJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionTypesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelineExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListWebhooksRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForThirdPartyJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutActionRevisionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutApprovalResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutWebhookRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RegisterWebhookWithThirdPartyRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RetryStageExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RollbackStageRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StartPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StopPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UpdateActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCodePipelineClient
implements CodePipelineClient {
    private static final Logger log = Logger.loggerFor(DefaultCodePipelineClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodePipelineClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcknowledgeJobResponse acknowledgeJob(AcknowledgeJobRequest acknowledgeJobRequest) throws ValidationException, InvalidNonceException, JobNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcknowledgeJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acknowledgeJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, acknowledgeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcknowledgeJob");
            AcknowledgeJobResponse acknowledgeJobResponse = (AcknowledgeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcknowledgeJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acknowledgeJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcknowledgeJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acknowledgeJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$acknowledgeJob$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcknowledgeThirdPartyJobResponse acknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) throws ValidationException, InvalidNonceException, JobNotFoundException, InvalidClientTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcknowledgeThirdPartyJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acknowledgeThirdPartyJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, acknowledgeThirdPartyJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcknowledgeThirdPartyJob");
            AcknowledgeThirdPartyJobResponse acknowledgeThirdPartyJobResponse = (AcknowledgeThirdPartyJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcknowledgeThirdPartyJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acknowledgeThirdPartyJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcknowledgeThirdPartyJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acknowledgeThirdPartyJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$acknowledgeThirdPartyJob$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomActionTypeResponse createCustomActionType(CreateCustomActionTypeRequest createCustomActionTypeRequest) throws ValidationException, LimitExceededException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomActionTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, createCustomActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomActionType");
            CreateCustomActionTypeResponse createCustomActionTypeResponse = (CreateCustomActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCustomActionTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomActionTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$createCustomActionType$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws ValidationException, PipelineNameInUseException, InvalidStageDeclarationException, InvalidActionDeclarationException, InvalidBlockerDeclarationException, InvalidStructureException, LimitExceededException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, createPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePipeline");
            CreatePipelineResponse createPipelineResponse = (CreatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$createPipeline$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomActionTypeResponse deleteCustomActionType(DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) throws ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomActionTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, deleteCustomActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomActionType");
            DeleteCustomActionTypeResponse deleteCustomActionTypeResponse = (DeleteCustomActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCustomActionTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomActionTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$deleteCustomActionType$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, deletePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePipeline");
            DeletePipelineResponse deletePipelineResponse = (DeletePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$deletePipeline$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWebhookResponse deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) throws ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, deleteWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWebhook");
            DeleteWebhookResponse deleteWebhookResponse = (DeleteWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWebhook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$deleteWebhook$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterWebhookWithThirdPartyResponse deregisterWebhookWithThirdParty(DeregisterWebhookWithThirdPartyRequest deregisterWebhookWithThirdPartyRequest) throws ValidationException, WebhookNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterWebhookWithThirdPartyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterWebhookWithThirdPartyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, deregisterWebhookWithThirdPartyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterWebhookWithThirdParty");
            DeregisterWebhookWithThirdPartyResponse deregisterWebhookWithThirdPartyResponse = (DeregisterWebhookWithThirdPartyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterWebhookWithThirdParty").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterWebhookWithThirdPartyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterWebhookWithThirdPartyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterWebhookWithThirdPartyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$deregisterWebhookWithThirdParty$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableStageTransitionResponse disableStageTransition(DisableStageTransitionRequest disableStageTransitionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableStageTransitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableStageTransitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, disableStageTransitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableStageTransition");
            DisableStageTransitionResponse disableStageTransitionResponse = (DisableStageTransitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableStageTransition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableStageTransitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableStageTransitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableStageTransitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$disableStageTransition$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableStageTransitionResponse enableStageTransition(EnableStageTransitionRequest enableStageTransitionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableStageTransitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableStageTransitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, enableStageTransitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableStageTransition");
            EnableStageTransitionResponse enableStageTransitionResponse = (EnableStageTransitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableStageTransition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableStageTransitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableStageTransitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableStageTransitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$enableStageTransition$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetActionTypeResponse getActionType(GetActionTypeRequest getActionTypeRequest) throws ActionTypeNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetActionTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetActionType");
            GetActionTypeResponse getActionTypeResponse = (GetActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getActionTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getActionTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getActionType$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobDetailsResponse getJobDetails(GetJobDetailsRequest getJobDetailsRequest) throws ValidationException, JobNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getJobDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobDetails");
            GetJobDetailsResponse getJobDetailsResponse = (GetJobDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getJobDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetJobDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getJobDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getJobDetails$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineResponse getPipeline(GetPipelineRequest getPipelineRequest) throws ValidationException, PipelineNotFoundException, PipelineVersionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipeline");
            GetPipelineResponse getPipelineResponse = (GetPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getPipeline$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineExecutionResponse getPipelineExecution(GetPipelineExecutionRequest getPipelineExecutionRequest) throws ValidationException, PipelineNotFoundException, PipelineExecutionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getPipelineExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineExecution");
            GetPipelineExecutionResponse getPipelineExecutionResponse = (GetPipelineExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPipelineExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getPipelineExecution$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineStateResponse getPipelineState(GetPipelineStateRequest getPipelineStateRequest) throws ValidationException, PipelineNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getPipelineStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineState");
            GetPipelineStateResponse getPipelineStateResponse = (GetPipelineStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPipelineStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getPipelineState$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetThirdPartyJobDetailsResponse getThirdPartyJobDetails(GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) throws JobNotFoundException, ValidationException, InvalidClientTokenException, InvalidJobException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetThirdPartyJobDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getThirdPartyJobDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getThirdPartyJobDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetThirdPartyJobDetails");
            GetThirdPartyJobDetailsResponse getThirdPartyJobDetailsResponse = (GetThirdPartyJobDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetThirdPartyJobDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getThirdPartyJobDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetThirdPartyJobDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getThirdPartyJobDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getThirdPartyJobDetails$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListActionExecutionsResponse listActionExecutions(ListActionExecutionsRequest listActionExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, PipelineExecutionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActionExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActionExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listActionExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActionExecutions");
            ListActionExecutionsResponse listActionExecutionsResponse = (ListActionExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActionExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listActionExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListActionExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listActionExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listActionExecutions$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListActionTypesResponse listActionTypes(ListActionTypesRequest listActionTypesRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActionTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActionTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listActionTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActionTypes");
            ListActionTypesResponse listActionTypesResponse = (ListActionTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActionTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listActionTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListActionTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listActionTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listActionTypes$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelineExecutionsResponse listPipelineExecutions(ListPipelineExecutionsRequest listPipelineExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelineExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelineExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listPipelineExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelineExecutions");
            ListPipelineExecutionsResponse listPipelineExecutionsResponse = (ListPipelineExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelineExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPipelineExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelineExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelineExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listPipelineExecutions$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listPipelinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelines");
            ListPipelinesResponse listPipelinesResponse = (ListPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPipelinesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelinesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listPipelines$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, InvalidArnException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listTagsForResource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWebhooksResponse listWebhooks(ListWebhooksRequest listWebhooksRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebhooksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWebhooksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listWebhooksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWebhooks");
            ListWebhooksResponse listWebhooksResponse = (ListWebhooksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebhooks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listWebhooksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWebhooksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWebhooksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listWebhooks$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollForJobsResponse pollForJobs(PollForJobsRequest pollForJobsRequest) throws ValidationException, ActionTypeNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pollForJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, pollForJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PollForJobs");
            PollForJobsResponse pollForJobsResponse = (PollForJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)pollForJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PollForJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return pollForJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$pollForJobs$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollForThirdPartyJobsResponse pollForThirdPartyJobs(PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) throws ActionTypeNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForThirdPartyJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pollForThirdPartyJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, pollForThirdPartyJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PollForThirdPartyJobs");
            PollForThirdPartyJobsResponse pollForThirdPartyJobsResponse = (PollForThirdPartyJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForThirdPartyJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)pollForThirdPartyJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PollForThirdPartyJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return pollForThirdPartyJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$pollForThirdPartyJobs$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutActionRevisionResponse putActionRevision(PutActionRevisionRequest putActionRevisionRequest) throws PipelineNotFoundException, StageNotFoundException, ActionNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutActionRevisionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putActionRevisionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putActionRevisionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutActionRevision");
            PutActionRevisionResponse putActionRevisionResponse = (PutActionRevisionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutActionRevision").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putActionRevisionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutActionRevisionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putActionRevisionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putActionRevision$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutApprovalResultResponse putApprovalResult(PutApprovalResultRequest putApprovalResultRequest) throws InvalidApprovalTokenException, ApprovalAlreadyCompletedException, PipelineNotFoundException, StageNotFoundException, ActionNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutApprovalResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putApprovalResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putApprovalResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutApprovalResult");
            PutApprovalResultResponse putApprovalResultResponse = (PutApprovalResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutApprovalResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putApprovalResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutApprovalResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putApprovalResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putApprovalResult$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutJobFailureResultResponse putJobFailureResult(PutJobFailureResultRequest putJobFailureResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutJobFailureResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putJobFailureResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putJobFailureResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobFailureResult");
            PutJobFailureResultResponse putJobFailureResultResponse = (PutJobFailureResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobFailureResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putJobFailureResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutJobFailureResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putJobFailureResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putJobFailureResult$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutJobSuccessResultResponse putJobSuccessResult(PutJobSuccessResultRequest putJobSuccessResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, OutputVariablesSizeExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutJobSuccessResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putJobSuccessResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putJobSuccessResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobSuccessResult");
            PutJobSuccessResultResponse putJobSuccessResultResponse = (PutJobSuccessResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobSuccessResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putJobSuccessResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutJobSuccessResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putJobSuccessResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putJobSuccessResult$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutThirdPartyJobFailureResultResponse putThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, InvalidClientTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutThirdPartyJobFailureResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putThirdPartyJobFailureResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putThirdPartyJobFailureResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutThirdPartyJobFailureResult");
            PutThirdPartyJobFailureResultResponse putThirdPartyJobFailureResultResponse = (PutThirdPartyJobFailureResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutThirdPartyJobFailureResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putThirdPartyJobFailureResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutThirdPartyJobFailureResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putThirdPartyJobFailureResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putThirdPartyJobFailureResult$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutThirdPartyJobSuccessResultResponse putThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, InvalidClientTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutThirdPartyJobSuccessResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putThirdPartyJobSuccessResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putThirdPartyJobSuccessResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutThirdPartyJobSuccessResult");
            PutThirdPartyJobSuccessResultResponse putThirdPartyJobSuccessResultResponse = (PutThirdPartyJobSuccessResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutThirdPartyJobSuccessResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putThirdPartyJobSuccessResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutThirdPartyJobSuccessResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putThirdPartyJobSuccessResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putThirdPartyJobSuccessResult$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutWebhookResponse putWebhook(PutWebhookRequest putWebhookRequest) throws ValidationException, LimitExceededException, InvalidWebhookFilterPatternException, InvalidWebhookAuthenticationParametersException, PipelineNotFoundException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutWebhook");
            PutWebhookResponse putWebhookResponse = (PutWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutWebhook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putWebhook$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterWebhookWithThirdPartyResponse registerWebhookWithThirdParty(RegisterWebhookWithThirdPartyRequest registerWebhookWithThirdPartyRequest) throws ValidationException, WebhookNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterWebhookWithThirdPartyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerWebhookWithThirdPartyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, registerWebhookWithThirdPartyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterWebhookWithThirdParty");
            RegisterWebhookWithThirdPartyResponse registerWebhookWithThirdPartyResponse = (RegisterWebhookWithThirdPartyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterWebhookWithThirdParty").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerWebhookWithThirdPartyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterWebhookWithThirdPartyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerWebhookWithThirdPartyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$registerWebhookWithThirdParty$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetryStageExecutionResponse retryStageExecution(RetryStageExecutionRequest retryStageExecutionRequest) throws ValidationException, ConflictException, PipelineNotFoundException, StageNotFoundException, StageNotRetryableException, NotLatestPipelineExecutionException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetryStageExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retryStageExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, retryStageExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetryStageExecution");
            RetryStageExecutionResponse retryStageExecutionResponse = (RetryStageExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetryStageExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)retryStageExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RetryStageExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return retryStageExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$retryStageExecution$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RollbackStageResponse rollbackStage(RollbackStageRequest rollbackStageRequest) throws ValidationException, ConflictException, PipelineNotFoundException, PipelineExecutionNotFoundException, PipelineExecutionOutdatedException, StageNotFoundException, UnableToRollbackStageException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RollbackStageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rollbackStageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, rollbackStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RollbackStage");
            RollbackStageResponse rollbackStageResponse = (RollbackStageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RollbackStage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rollbackStageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RollbackStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rollbackStageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$rollbackStage$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPipelineExecutionResponse startPipelineExecution(StartPipelineExecutionRequest startPipelineExecutionRequest) throws ValidationException, ConflictException, PipelineNotFoundException, ConcurrentPipelineExecutionsLimitExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPipelineExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startPipelineExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, startPipelineExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPipelineExecution");
            StartPipelineExecutionResponse startPipelineExecutionResponse = (StartPipelineExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPipelineExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startPipelineExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startPipelineExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$startPipelineExecution$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopPipelineExecutionResponse stopPipelineExecution(StopPipelineExecutionRequest stopPipelineExecutionRequest) throws ValidationException, ConflictException, PipelineNotFoundException, PipelineExecutionNotStoppableException, DuplicatedStopRequestException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPipelineExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopPipelineExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, stopPipelineExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPipelineExecution");
            StopPipelineExecutionResponse stopPipelineExecutionResponse = (StopPipelineExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPipelineExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopPipelineExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopPipelineExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$stopPipelineExecution$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidArnException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$tagResource$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidArnException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$untagResource$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateActionTypeResponse updateActionType(UpdateActionTypeRequest updateActionTypeRequest) throws RequestFailedException, ValidationException, ActionTypeNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateActionTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, updateActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateActionType");
            UpdateActionTypeResponse updateActionTypeResponse = (UpdateActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateActionTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateActionTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$updateActionType$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws ValidationException, InvalidStageDeclarationException, InvalidActionDeclarationException, InvalidBlockerDeclarationException, InvalidStructureException, LimitExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, updatePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePipeline");
            UpdatePipelineResponse updatePipelineResponse = (UpdatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$updatePipeline$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "codepipeline";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CodePipelineServiceClientConfigurationBuilder serviceConfigBuilder = new CodePipelineServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodePipelineException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").exceptionBuilderSupplier(InvalidActionDeclarationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArnException").exceptionBuilderSupplier(InvalidArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").exceptionBuilderSupplier(PipelineNameInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidJobException").exceptionBuilderSupplier(InvalidJobException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").exceptionBuilderSupplier(ActionTypeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StageNotFoundException").exceptionBuilderSupplier(StageNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").exceptionBuilderSupplier(DuplicatedStopRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagsException").exceptionBuilderSupplier(InvalidTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActionNotFoundException").exceptionBuilderSupplier(ActionNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").exceptionBuilderSupplier(InvalidStageDeclarationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestFailedException").exceptionBuilderSupplier(RequestFailedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").exceptionBuilderSupplier(InvalidClientTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidJobStateException").exceptionBuilderSupplier(InvalidJobStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").exceptionBuilderSupplier(WebhookNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").exceptionBuilderSupplier(InvalidApprovalTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").exceptionBuilderSupplier(PipelineNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StageNotRetryableException").exceptionBuilderSupplier(StageNotRetryableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStructureException").exceptionBuilderSupplier(InvalidStructureException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").exceptionBuilderSupplier(UnableToRollbackStageException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNonceException").exceptionBuilderSupplier(InvalidNonceException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("JobNotFoundException").exceptionBuilderSupplier(JobNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final CodePipelineServiceClientConfiguration serviceClientConfiguration() {
        return new CodePipelineServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updatePipeline$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateActionType$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPipelineExecution$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPipelineExecution$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rollbackStage$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retryStageExecution$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerWebhookWithThirdParty$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putWebhook$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putThirdPartyJobSuccessResult$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putThirdPartyJobFailureResult$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobSuccessResult$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobFailureResult$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putApprovalResult$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putActionRevision$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pollForThirdPartyJobs$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pollForJobs$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWebhooks$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelines$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelineExecutions$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActionTypes$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActionExecutions$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getThirdPartyJobDetails$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineState$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineExecution$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipeline$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobDetails$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getActionType$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableStageTransition$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableStageTransition$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterWebhookWithThirdParty$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWebhook$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePipeline$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomActionType$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPipeline$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomActionType$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acknowledgeThirdPartyJob$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acknowledgeJob$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

