/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.StageRetryMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetryConfiguration> {
    private static final SdkField<String> RETRY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retryMode").getter(RetryConfiguration.getter(RetryConfiguration::retryModeAsString)).setter(RetryConfiguration.setter(Builder::retryMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRY_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String retryMode;

    private RetryConfiguration(BuilderImpl builder) {
        this.retryMode = builder.retryMode;
    }

    public final StageRetryMode retryMode() {
        return StageRetryMode.fromValue(this.retryMode);
    }

    public final String retryModeAsString() {
        return this.retryMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retryModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryConfiguration)) {
            return false;
        }
        RetryConfiguration other = (RetryConfiguration)obj;
        return Objects.equals(this.retryModeAsString(), other.retryModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RetryConfiguration").add("RetryMode", (Object)this.retryModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "retryMode": {
                return Optional.ofNullable(clazz.cast(this.retryModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryConfiguration, T> g) {
        return obj -> g.apply((RetryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String retryMode;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryConfiguration model) {
            this.retryMode(model.retryMode);
        }

        public final String getRetryMode() {
            return this.retryMode;
        }

        public final void setRetryMode(String retryMode) {
            this.retryMode = retryMode;
        }

        @Override
        public final Builder retryMode(String retryMode) {
            this.retryMode = retryMode;
            return this;
        }

        @Override
        public final Builder retryMode(StageRetryMode retryMode) {
            this.retryMode(retryMode == null ? null : retryMode.toString());
            return this;
        }

        public RetryConfiguration build() {
            return new RetryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetryConfiguration> {
        public Builder retryMode(String var1);

        public Builder retryMode(StageRetryMode var1);
    }
}

