/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationMapCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetail;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetailListCopier;
import software.amazon.awssdk.services.codepipeline.model.ResolvedActionConfigurationMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionExecutionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionExecutionInput> {
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionTypeId").getter(ActionExecutionInput.getter(ActionExecutionInput::actionTypeId)).setter(ActionExecutionInput.setter(Builder::actionTypeId)).constructor(ActionTypeId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()}).build();
    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configuration").getter(ActionExecutionInput.getter(ActionExecutionInput::configuration)).setter(ActionExecutionInput.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESOLVED_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("resolvedConfiguration").getter(ActionExecutionInput.getter(ActionExecutionInput::resolvedConfiguration)).setter(ActionExecutionInput.setter(Builder::resolvedConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ActionExecutionInput.getter(ActionExecutionInput::roleArn)).setter(ActionExecutionInput.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(ActionExecutionInput.getter(ActionExecutionInput::region)).setter(ActionExecutionInput.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<List<ArtifactDetail>> INPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputArtifacts").getter(ActionExecutionInput.getter(ActionExecutionInput::inputArtifacts)).setter(ActionExecutionInput.setter(Builder::inputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArtifactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ActionExecutionInput.getter(ActionExecutionInput::namespace)).setter(ActionExecutionInput.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_ID_FIELD, CONFIGURATION_FIELD, RESOLVED_CONFIGURATION_FIELD, ROLE_ARN_FIELD, REGION_FIELD, INPUT_ARTIFACTS_FIELD, NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionTypeId", ACTION_TYPE_ID_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("resolvedConfiguration", RESOLVED_CONFIGURATION_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("region", REGION_FIELD);
            this.put("inputArtifacts", INPUT_ARTIFACTS_FIELD);
            this.put("namespace", NAMESPACE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ActionTypeId actionTypeId;
    private final Map<String, String> configuration;
    private final Map<String, String> resolvedConfiguration;
    private final String roleArn;
    private final String region;
    private final List<ArtifactDetail> inputArtifacts;
    private final String namespace;

    private ActionExecutionInput(BuilderImpl builder) {
        this.actionTypeId = builder.actionTypeId;
        this.configuration = builder.configuration;
        this.resolvedConfiguration = builder.resolvedConfiguration;
        this.roleArn = builder.roleArn;
        this.region = builder.region;
        this.inputArtifacts = builder.inputArtifacts;
        this.namespace = builder.namespace;
    }

    public final ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> configuration() {
        return this.configuration;
    }

    public final boolean hasResolvedConfiguration() {
        return this.resolvedConfiguration != null && !(this.resolvedConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resolvedConfiguration() {
        return this.resolvedConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasInputArtifacts() {
        return this.inputArtifacts != null && !(this.inputArtifacts instanceof SdkAutoConstructList);
    }

    public final List<ArtifactDetail> inputArtifacts() {
        return this.inputArtifacts;
    }

    public final String namespace() {
        return this.namespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolvedConfiguration() ? this.resolvedConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputArtifacts() ? this.inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionInput)) {
            return false;
        }
        ActionExecutionInput other = (ActionExecutionInput)obj;
        return Objects.equals(this.actionTypeId(), other.actionTypeId()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration()) && this.hasResolvedConfiguration() == other.hasResolvedConfiguration() && Objects.equals(this.resolvedConfiguration(), other.resolvedConfiguration()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.region(), other.region()) && this.hasInputArtifacts() == other.hasInputArtifacts() && Objects.equals(this.inputArtifacts(), other.inputArtifacts()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"ActionExecutionInput").add("ActionTypeId", (Object)this.actionTypeId()).add("Configuration", this.hasConfiguration() ? this.configuration() : null).add("ResolvedConfiguration", this.hasResolvedConfiguration() ? this.resolvedConfiguration() : null).add("RoleArn", (Object)this.roleArn()).add("Region", (Object)this.region()).add("InputArtifacts", this.hasInputArtifacts() ? this.inputArtifacts() : null).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionTypeId": {
                return Optional.ofNullable(clazz.cast(this.actionTypeId()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "resolvedConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resolvedConfiguration()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "inputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.inputArtifacts()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionInput, T> g) {
        return obj -> g.apply((ActionExecutionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActionTypeId actionTypeId;
        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> resolvedConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String roleArn;
        private String region;
        private List<ArtifactDetail> inputArtifacts = DefaultSdkAutoConstructList.getInstance();
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionInput model) {
            this.actionTypeId(model.actionTypeId);
            this.configuration(model.configuration);
            this.resolvedConfiguration(model.resolvedConfiguration);
            this.roleArn(model.roleArn);
            this.region(model.region);
            this.inputArtifacts(model.inputArtifacts);
            this.namespace(model.namespace);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return this.actionTypeId != null ? this.actionTypeId.toBuilder() : null;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final Map<String, String> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configuration;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
            return this;
        }

        public final Map<String, String> getResolvedConfiguration() {
            if (this.resolvedConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resolvedConfiguration;
        }

        public final void setResolvedConfiguration(Map<String, String> resolvedConfiguration) {
            this.resolvedConfiguration = ResolvedActionConfigurationMapCopier.copy(resolvedConfiguration);
        }

        @Override
        public final Builder resolvedConfiguration(Map<String, String> resolvedConfiguration) {
            this.resolvedConfiguration = ResolvedActionConfigurationMapCopier.copy(resolvedConfiguration);
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<ArtifactDetail.Builder> getInputArtifacts() {
            List<ArtifactDetail.Builder> result = ArtifactDetailListCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputArtifacts(Collection<ArtifactDetail.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = ArtifactDetailListCopier.copyFromBuilder(inputArtifacts);
        }

        @Override
        public final Builder inputArtifacts(Collection<ArtifactDetail> inputArtifacts) {
            this.inputArtifacts = ArtifactDetailListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(ArtifactDetail ... inputArtifacts) {
            this.inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(Consumer<ArtifactDetail.Builder> ... inputArtifacts) {
            this.inputArtifacts(Stream.of(inputArtifacts).map(c -> (ArtifactDetail)((ArtifactDetail.Builder)ArtifactDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ActionExecutionInput build() {
            return new ActionExecutionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionExecutionInput> {
        public Builder actionTypeId(ActionTypeId var1);

        default public Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return this.actionTypeId((ActionTypeId)((ActionTypeId.Builder)ActionTypeId.builder().applyMutation(actionTypeId)).build());
        }

        public Builder configuration(Map<String, String> var1);

        public Builder resolvedConfiguration(Map<String, String> var1);

        public Builder roleArn(String var1);

        public Builder region(String var1);

        public Builder inputArtifacts(Collection<ArtifactDetail> var1);

        public Builder inputArtifacts(ArtifactDetail ... var1);

        public Builder inputArtifacts(Consumer<ArtifactDetail.Builder> ... var1);

        public Builder namespace(String var1);
    }
}

