/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ActionOwner;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActionTypesRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, ListActionTypesRequest> {
    private static final SdkField<String> ACTION_OWNER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionOwnerFilter").getter(ListActionTypesRequest.getter(ListActionTypesRequest::actionOwnerFilterAsString)).setter(ListActionTypesRequest.setter(Builder::actionOwnerFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionOwnerFilter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListActionTypesRequest.getter(ListActionTypesRequest::nextToken)).setter(ListActionTypesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> REGION_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionFilter").getter(ListActionTypesRequest.getter(ListActionTypesRequest::regionFilter)).setter(ListActionTypesRequest.setter(Builder::regionFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_OWNER_FILTER_FIELD, NEXT_TOKEN_FIELD, REGION_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionOwnerFilter", ACTION_OWNER_FILTER_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("regionFilter", REGION_FILTER_FIELD);
        }
    });
    private final String actionOwnerFilter;
    private final String nextToken;
    private final String regionFilter;

    private ListActionTypesRequest(BuilderImpl builder) {
        super(builder);
        this.actionOwnerFilter = builder.actionOwnerFilter;
        this.nextToken = builder.nextToken;
        this.regionFilter = builder.regionFilter;
    }

    public final ActionOwner actionOwnerFilter() {
        return ActionOwner.fromValue(this.actionOwnerFilter);
    }

    public final String actionOwnerFilterAsString() {
        return this.actionOwnerFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String regionFilter() {
        return this.regionFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionOwnerFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionTypesRequest)) {
            return false;
        }
        ListActionTypesRequest other = (ListActionTypesRequest)((Object)obj);
        return Objects.equals(this.actionOwnerFilterAsString(), other.actionOwnerFilterAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.regionFilter(), other.regionFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListActionTypesRequest").add("ActionOwnerFilter", (Object)this.actionOwnerFilterAsString()).add("NextToken", (Object)this.nextToken()).add("RegionFilter", (Object)this.regionFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionOwnerFilter": {
                return Optional.ofNullable(clazz.cast(this.actionOwnerFilterAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "regionFilter": {
                return Optional.ofNullable(clazz.cast(this.regionFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListActionTypesRequest, T> g) {
        return obj -> g.apply((ListActionTypesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String actionOwnerFilter;
        private String nextToken;
        private String regionFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionTypesRequest model) {
            super(model);
            this.actionOwnerFilter(model.actionOwnerFilter);
            this.nextToken(model.nextToken);
            this.regionFilter(model.regionFilter);
        }

        public final String getActionOwnerFilter() {
            return this.actionOwnerFilter;
        }

        public final void setActionOwnerFilter(String actionOwnerFilter) {
            this.actionOwnerFilter = actionOwnerFilter;
        }

        @Override
        public final Builder actionOwnerFilter(String actionOwnerFilter) {
            this.actionOwnerFilter = actionOwnerFilter;
            return this;
        }

        @Override
        public final Builder actionOwnerFilter(ActionOwner actionOwnerFilter) {
            this.actionOwnerFilter(actionOwnerFilter == null ? null : actionOwnerFilter.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRegionFilter() {
            return this.regionFilter;
        }

        public final void setRegionFilter(String regionFilter) {
            this.regionFilter = regionFilter;
        }

        @Override
        public final Builder regionFilter(String regionFilter) {
            this.regionFilter = regionFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListActionTypesRequest build() {
            return new ListActionTypesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActionTypesRequest> {
        public Builder actionOwnerFilter(String var1);

        public Builder actionOwnerFilter(ActionOwner var1);

        public Builder nextToken(String var1);

        public Builder regionFilter(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

