/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStore;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStoreMapCopier;
import software.amazon.awssdk.services.codepipeline.model.ExecutionMode;
import software.amazon.awssdk.services.codepipeline.model.PipelineStageDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.PipelineTriggerDeclaration;
import software.amazon.awssdk.services.codepipeline.model.PipelineTriggerDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.PipelineType;
import software.amazon.awssdk.services.codepipeline.model.PipelineVariableDeclaration;
import software.amazon.awssdk.services.codepipeline.model.PipelineVariableDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageDeclaration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PipelineDeclaration.getter(PipelineDeclaration::name)).setter(PipelineDeclaration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(PipelineDeclaration.getter(PipelineDeclaration::roleArn)).setter(PipelineDeclaration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ArtifactStore> ARTIFACT_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifactStore").getter(PipelineDeclaration.getter(PipelineDeclaration::artifactStore)).setter(PipelineDeclaration.setter(Builder::artifactStore)).constructor(ArtifactStore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStore").build()}).build();
    private static final SdkField<Map<String, ArtifactStore>> ARTIFACT_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("artifactStores").getter(PipelineDeclaration.getter(PipelineDeclaration::artifactStores)).setter(PipelineDeclaration.setter(Builder::artifactStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStores").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArtifactStore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<StageDeclaration>> STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stages").getter(PipelineDeclaration.getter(PipelineDeclaration::stages)).setter(PipelineDeclaration.setter(Builder::stages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StageDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("version").getter(PipelineDeclaration.getter(PipelineDeclaration::version)).setter(PipelineDeclaration.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> EXECUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionMode").getter(PipelineDeclaration.getter(PipelineDeclaration::executionModeAsString)).setter(PipelineDeclaration.setter(Builder::executionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionMode").build()}).build();
    private static final SdkField<String> PIPELINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineType").getter(PipelineDeclaration.getter(PipelineDeclaration::pipelineTypeAsString)).setter(PipelineDeclaration.setter(Builder::pipelineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineType").build()}).build();
    private static final SdkField<List<PipelineVariableDeclaration>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(PipelineDeclaration.getter(PipelineDeclaration::variables)).setter(PipelineDeclaration.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineVariableDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PipelineTriggerDeclaration>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggers").getter(PipelineDeclaration.getter(PipelineDeclaration::triggers)).setter(PipelineDeclaration.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineTriggerDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_ARN_FIELD, ARTIFACT_STORE_FIELD, ARTIFACT_STORES_FIELD, STAGES_FIELD, VERSION_FIELD, EXECUTION_MODE_FIELD, PIPELINE_TYPE_FIELD, VARIABLES_FIELD, TRIGGERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("artifactStore", ARTIFACT_STORE_FIELD);
            this.put("artifactStores", ARTIFACT_STORES_FIELD);
            this.put("stages", STAGES_FIELD);
            this.put("version", VERSION_FIELD);
            this.put("executionMode", EXECUTION_MODE_FIELD);
            this.put("pipelineType", PIPELINE_TYPE_FIELD);
            this.put("variables", VARIABLES_FIELD);
            this.put("triggers", TRIGGERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String roleArn;
    private final ArtifactStore artifactStore;
    private final Map<String, ArtifactStore> artifactStores;
    private final List<StageDeclaration> stages;
    private final Integer version;
    private final String executionMode;
    private final String pipelineType;
    private final List<PipelineVariableDeclaration> variables;
    private final List<PipelineTriggerDeclaration> triggers;

    private PipelineDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.artifactStore = builder.artifactStore;
        this.artifactStores = builder.artifactStores;
        this.stages = builder.stages;
        this.version = builder.version;
        this.executionMode = builder.executionMode;
        this.pipelineType = builder.pipelineType;
        this.variables = builder.variables;
        this.triggers = builder.triggers;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ArtifactStore artifactStore() {
        return this.artifactStore;
    }

    public final boolean hasArtifactStores() {
        return this.artifactStores != null && !(this.artifactStores instanceof SdkAutoConstructMap);
    }

    public final Map<String, ArtifactStore> artifactStores() {
        return this.artifactStores;
    }

    public final boolean hasStages() {
        return this.stages != null && !(this.stages instanceof SdkAutoConstructList);
    }

    public final List<StageDeclaration> stages() {
        return this.stages;
    }

    public final Integer version() {
        return this.version;
    }

    public final ExecutionMode executionMode() {
        return ExecutionMode.fromValue(this.executionMode);
    }

    public final String executionModeAsString() {
        return this.executionMode;
    }

    public final PipelineType pipelineType() {
        return PipelineType.fromValue(this.pipelineType);
    }

    public final String pipelineTypeAsString() {
        return this.pipelineType;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public final List<PipelineVariableDeclaration> variables() {
        return this.variables;
    }

    public final boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public final List<PipelineTriggerDeclaration> triggers() {
        return this.triggers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifactStores() ? this.artifactStores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStages() ? this.stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggers() ? this.triggers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDeclaration)) {
            return false;
        }
        PipelineDeclaration other = (PipelineDeclaration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.artifactStore(), other.artifactStore()) && this.hasArtifactStores() == other.hasArtifactStores() && Objects.equals(this.artifactStores(), other.artifactStores()) && this.hasStages() == other.hasStages() && Objects.equals(this.stages(), other.stages()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.executionModeAsString(), other.executionModeAsString()) && Objects.equals(this.pipelineTypeAsString(), other.pipelineTypeAsString()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && this.hasTriggers() == other.hasTriggers() && Objects.equals(this.triggers(), other.triggers());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineDeclaration").add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("ArtifactStore", (Object)this.artifactStore()).add("ArtifactStores", this.hasArtifactStores() ? this.artifactStores() : null).add("Stages", this.hasStages() ? this.stages() : null).add("Version", (Object)this.version()).add("ExecutionMode", (Object)this.executionModeAsString()).add("PipelineType", (Object)this.pipelineTypeAsString()).add("Variables", this.hasVariables() ? this.variables() : null).add("Triggers", this.hasTriggers() ? this.triggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "artifactStore": {
                return Optional.ofNullable(clazz.cast(this.artifactStore()));
            }
            case "artifactStores": {
                return Optional.ofNullable(clazz.cast(this.artifactStores()));
            }
            case "stages": {
                return Optional.ofNullable(clazz.cast(this.stages()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "executionMode": {
                return Optional.ofNullable(clazz.cast(this.executionModeAsString()));
            }
            case "pipelineType": {
                return Optional.ofNullable(clazz.cast(this.pipelineTypeAsString()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PipelineDeclaration, T> g) {
        return obj -> g.apply((PipelineDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String roleArn;
        private ArtifactStore artifactStore;
        private Map<String, ArtifactStore> artifactStores = DefaultSdkAutoConstructMap.getInstance();
        private List<StageDeclaration> stages = DefaultSdkAutoConstructList.getInstance();
        private Integer version;
        private String executionMode;
        private String pipelineType;
        private List<PipelineVariableDeclaration> variables = DefaultSdkAutoConstructList.getInstance();
        private List<PipelineTriggerDeclaration> triggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDeclaration model) {
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.artifactStore(model.artifactStore);
            this.artifactStores(model.artifactStores);
            this.stages(model.stages);
            this.version(model.version);
            this.executionMode(model.executionMode);
            this.pipelineType(model.pipelineType);
            this.variables(model.variables);
            this.triggers(model.triggers);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ArtifactStore.Builder getArtifactStore() {
            return this.artifactStore != null ? this.artifactStore.toBuilder() : null;
        }

        public final void setArtifactStore(ArtifactStore.BuilderImpl artifactStore) {
            this.artifactStore = artifactStore != null ? artifactStore.build() : null;
        }

        @Override
        public final Builder artifactStore(ArtifactStore artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        public final Map<String, ArtifactStore.Builder> getArtifactStores() {
            Map<String, ArtifactStore.Builder> result = ArtifactStoreMapCopier.copyToBuilder(this.artifactStores);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setArtifactStores(Map<String, ArtifactStore.BuilderImpl> artifactStores) {
            this.artifactStores = ArtifactStoreMapCopier.copyFromBuilder(artifactStores);
        }

        @Override
        public final Builder artifactStores(Map<String, ArtifactStore> artifactStores) {
            this.artifactStores = ArtifactStoreMapCopier.copy(artifactStores);
            return this;
        }

        public final List<StageDeclaration.Builder> getStages() {
            List<StageDeclaration.Builder> result = PipelineStageDeclarationListCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStages(Collection<StageDeclaration.BuilderImpl> stages) {
            this.stages = PipelineStageDeclarationListCopier.copyFromBuilder(stages);
        }

        @Override
        public final Builder stages(Collection<StageDeclaration> stages) {
            this.stages = PipelineStageDeclarationListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(StageDeclaration ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<StageDeclaration.Builder> ... stages) {
            this.stages(Stream.of(stages).map(c -> (StageDeclaration)((StageDeclaration.Builder)StageDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final String getExecutionMode() {
            return this.executionMode;
        }

        public final void setExecutionMode(String executionMode) {
            this.executionMode = executionMode;
        }

        @Override
        public final Builder executionMode(String executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        @Override
        public final Builder executionMode(ExecutionMode executionMode) {
            this.executionMode(executionMode == null ? null : executionMode.toString());
            return this;
        }

        public final String getPipelineType() {
            return this.pipelineType;
        }

        public final void setPipelineType(String pipelineType) {
            this.pipelineType = pipelineType;
        }

        @Override
        public final Builder pipelineType(String pipelineType) {
            this.pipelineType = pipelineType;
            return this;
        }

        @Override
        public final Builder pipelineType(PipelineType pipelineType) {
            this.pipelineType(pipelineType == null ? null : pipelineType.toString());
            return this;
        }

        public final List<PipelineVariableDeclaration.Builder> getVariables() {
            List<PipelineVariableDeclaration.Builder> result = PipelineVariableDeclarationListCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<PipelineVariableDeclaration.BuilderImpl> variables) {
            this.variables = PipelineVariableDeclarationListCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<PipelineVariableDeclaration> variables) {
            this.variables = PipelineVariableDeclarationListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(PipelineVariableDeclaration ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<PipelineVariableDeclaration.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (PipelineVariableDeclaration)((PipelineVariableDeclaration.Builder)PipelineVariableDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PipelineTriggerDeclaration.Builder> getTriggers() {
            List<PipelineTriggerDeclaration.Builder> result = PipelineTriggerDeclarationListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<PipelineTriggerDeclaration.BuilderImpl> triggers) {
            this.triggers = PipelineTriggerDeclarationListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<PipelineTriggerDeclaration> triggers) {
            this.triggers = PipelineTriggerDeclarationListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(PipelineTriggerDeclaration ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<PipelineTriggerDeclaration.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (PipelineTriggerDeclaration)((PipelineTriggerDeclaration.Builder)PipelineTriggerDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PipelineDeclaration build() {
            return new PipelineDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineDeclaration> {
        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder artifactStore(ArtifactStore var1);

        default public Builder artifactStore(Consumer<ArtifactStore.Builder> artifactStore) {
            return this.artifactStore((ArtifactStore)((ArtifactStore.Builder)ArtifactStore.builder().applyMutation(artifactStore)).build());
        }

        public Builder artifactStores(Map<String, ArtifactStore> var1);

        public Builder stages(Collection<StageDeclaration> var1);

        public Builder stages(StageDeclaration ... var1);

        public Builder stages(Consumer<StageDeclaration.Builder> ... var1);

        public Builder version(Integer var1);

        public Builder executionMode(String var1);

        public Builder executionMode(ExecutionMode var1);

        public Builder pipelineType(String var1);

        public Builder pipelineType(PipelineType var1);

        public Builder variables(Collection<PipelineVariableDeclaration> var1);

        public Builder variables(PipelineVariableDeclaration ... var1);

        public Builder variables(Consumer<PipelineVariableDeclaration.Builder> ... var1);

        public Builder triggers(Collection<PipelineTriggerDeclaration> var1);

        public Builder triggers(PipelineTriggerDeclaration ... var1);

        public Builder triggers(Consumer<PipelineTriggerDeclaration.Builder> ... var1);
    }
}

