/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ExecutionMode;
import software.amazon.awssdk.services.codepipeline.model.PipelineType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PipelineSummary.getter(PipelineSummary::name)).setter(PipelineSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("version").getter(PipelineSummary.getter(PipelineSummary::version)).setter(PipelineSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> PIPELINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineType").getter(PipelineSummary.getter(PipelineSummary::pipelineTypeAsString)).setter(PipelineSummary.setter(Builder::pipelineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineType").build()}).build();
    private static final SdkField<String> EXECUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionMode").getter(PipelineSummary.getter(PipelineSummary::executionModeAsString)).setter(PipelineSummary.setter(Builder::executionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionMode").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(PipelineSummary.getter(PipelineSummary::created)).setter(PipelineSummary.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<Instant> UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updated").getter(PipelineSummary.getter(PipelineSummary::updated)).setter(PipelineSummary.setter(Builder::updated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD, PIPELINE_TYPE_FIELD, EXECUTION_MODE_FIELD, CREATED_FIELD, UPDATED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("version", VERSION_FIELD);
            this.put("pipelineType", PIPELINE_TYPE_FIELD);
            this.put("executionMode", EXECUTION_MODE_FIELD);
            this.put("created", CREATED_FIELD);
            this.put("updated", UPDATED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer version;
    private final String pipelineType;
    private final String executionMode;
    private final Instant created;
    private final Instant updated;

    private PipelineSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.pipelineType = builder.pipelineType;
        this.executionMode = builder.executionMode;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public final String name() {
        return this.name;
    }

    public final Integer version() {
        return this.version;
    }

    public final PipelineType pipelineType() {
        return PipelineType.fromValue(this.pipelineType);
    }

    public final String pipelineTypeAsString() {
        return this.pipelineType;
    }

    public final ExecutionMode executionMode() {
        return ExecutionMode.fromValue(this.executionMode);
    }

    public final String executionModeAsString() {
        return this.executionMode;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant updated() {
        return this.updated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.updated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.pipelineTypeAsString(), other.pipelineTypeAsString()) && Objects.equals(this.executionModeAsString(), other.executionModeAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.updated(), other.updated());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineSummary").add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("PipelineType", (Object)this.pipelineTypeAsString()).add("ExecutionMode", (Object)this.executionModeAsString()).add("Created", (Object)this.created()).add("Updated", (Object)this.updated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "pipelineType": {
                return Optional.ofNullable(clazz.cast(this.pipelineTypeAsString()));
            }
            case "executionMode": {
                return Optional.ofNullable(clazz.cast(this.executionModeAsString()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "updated": {
                return Optional.ofNullable(clazz.cast(this.updated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PipelineSummary, T> g) {
        return obj -> g.apply((PipelineSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer version;
        private String pipelineType;
        private String executionMode;
        private Instant created;
        private Instant updated;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineSummary model) {
            this.name(model.name);
            this.version(model.version);
            this.pipelineType(model.pipelineType);
            this.executionMode(model.executionMode);
            this.created(model.created);
            this.updated(model.updated);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final String getPipelineType() {
            return this.pipelineType;
        }

        public final void setPipelineType(String pipelineType) {
            this.pipelineType = pipelineType;
        }

        @Override
        public final Builder pipelineType(String pipelineType) {
            this.pipelineType = pipelineType;
            return this;
        }

        @Override
        public final Builder pipelineType(PipelineType pipelineType) {
            this.pipelineType(pipelineType == null ? null : pipelineType.toString());
            return this;
        }

        public final String getExecutionMode() {
            return this.executionMode;
        }

        public final void setExecutionMode(String executionMode) {
            this.executionMode = executionMode;
        }

        @Override
        public final Builder executionMode(String executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        @Override
        public final Builder executionMode(ExecutionMode executionMode) {
            this.executionMode(executionMode == null ? null : executionMode.toString());
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getUpdated() {
            return this.updated;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        @Override
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public PipelineSummary build() {
            return new PipelineSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineSummary> {
        public Builder name(String var1);

        public Builder version(Integer var1);

        public Builder pipelineType(String var1);

        public Builder pipelineType(PipelineType var1);

        public Builder executionMode(String var1);

        public Builder executionMode(ExecutionMode var1);

        public Builder created(Instant var1);

        public Builder updated(Instant var1);
    }
}

